<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method exportByParams(array $params)
 * @method staffAnniversaryNoticeByParams(array $params)
 * @method hrbpAnniversaryNoticeByParams(array $params)
 * @method increaseAnniversaryByParams(array $params)
 * @method checkStaffAnniversaryPassByParams(array $params)
 * @method getStaffAnniversaryHistoryByParams(array $params)
 */
class Anniversary {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 周年员工列表
     *
     * @support  array $staffIds 工号 [ require false ]
     * @support  int $year 年份 [ require false ]
     * @support  int $month 月份 [ require false ]
     * @support  int $day 日期 [ require false ]
     * @support  array $serial 周年数 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 15) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 周年员工导出
     *
     * @support  array $staffIds 工号 [ require false ]
     * @support  int $year 年份 [ require false ]
     * @support  int $month 月份 [ require false ]
     * @support  int $day 日期 [ require false ]
     * @support  array $serial 周年数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function export () {
        return self::getClass()->export([
        ]);
    }

    /**
     * 周年伙伴祝福推送
     *
     * @param  string $date 模拟今日 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function staffAnniversaryNotice (string $date = null) {
        return self::getClass()->staffAnniversaryNotice([
            "date" => $date,
        ]);
    }

    /**
     * 周年HRBP消息推送
     *
     * @param  int $day 日期 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hrbpAnniversaryNotice (int $day = null) {
        return self::getClass()->hrbpAnniversaryNotice([
            "day" => $day,
        ]);
    }

    /**
     * 递增下一年纪念日
     *
     * @param  string $date 模拟今日 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function increaseAnniversary (string $date = null) {
        return self::getClass()->increaseAnniversary([
            "date" => $date,
        ]);
    }

    /**
     * 校验纪念日是否已过
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  int $serial 周年数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkStaffAnniversaryPass (int $staffId, int $serial) {
        return self::getClass()->checkStaffAnniversaryPass([
            "staffId" => $staffId,
            "serial" => $serial,
        ]);
    }

    /**
     * 已庆祝过的纪念日
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffAnniversaryHistory (int $staffId) {
        return self::getClass()->getStaffAnniversaryHistory([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Anniversary');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Anniversary');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}