<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method staffAnniversaryNoticeByParams(array $params)
 * @method hrbpAnniversaryNoticeByParams(array $params)
 * @method increaseAnniversaryByParams(array $params)
 * @method checkStaffAnniversaryPassByParams(array $params)
 * @method getStaffAnniversaryHistoryByParams(array $params)
 */
class Anniversary {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 周年员工列表
     *
     * @support  array $staffIds 工号 [ require false ]
     * @support  int $year 年份 [ require false ]
     * @support  int $month 月份 [ require false ]
     * @support  int $day 日期 [ require false ]
     * @support  array $serial 周年数 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 15) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 周年伙伴祝福推送
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function staffAnniversaryNotice () {
        return self::getClass()->staffAnniversaryNotice();
    }

    /**
     * 周年HRBP消息推送
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function hrbpAnniversaryNotice () {
        return self::getClass()->hrbpAnniversaryNotice();
    }

    /**
     * 递增下一年纪念日
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function increaseAnniversary () {
        return self::getClass()->increaseAnniversary();
    }

    /**
     * 校验是否已过纪念日
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  int $serial 周年数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkStaffAnniversaryPass (int $staffId, int $serial) {
        return self::getClass()->checkStaffAnniversaryPass([
            "staffId" => $staffId,
            "serial" => $serial,
        ]);
    }

    /**
     * 获取伙伴历史纪念日
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffAnniversaryHistory (int $staffId) {
        return self::getClass()->getStaffAnniversaryHistory([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Anniversary');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Anniversary');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}