<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-10 17:00:31
 */
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Anniversary
 */
class Anniversary {
    private static string $serviceName = "Staff";

    private static string $className = "Anniversary";

    /**
     * 周年员工列表
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 15, array $staffIds, int $year, int $month, int $day, array $serial) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "staffIds" => $staffIds, "year" => $year, "month" => $month, "day" => $day, "serial" => $serial]);
    }
    /**
     * 周年员工导出
     * @return  array
    */
    public static function export (array $staffIds, int $year, int $month, int $day, array $serial) {
        return RpcClass::getClass(self::$serviceName, self::$className)->export(["staffIds" => $staffIds, "year" => $year, "month" => $month, "day" => $day, "serial" => $serial]);
    }
    /**
     * 周年伙伴祝福推送
     * @return  bool
    */
    public static function staffAnniversaryNotice (string $date = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffAnniversaryNotice(["date" => $date]);
    }
    /**
     * 周年HRBP消息推送
     * @return  bool
    */
    public static function hrbpAnniversaryNotice (int $day = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hrbpAnniversaryNotice(["day" => $day]);
    }
    /**
     * 递增下一年纪念日
     * @return  bool
    */
    public static function increaseAnniversary (string $date = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->increaseAnniversary(["date" => $date]);
    }
    /**
     * 校验纪念日是否已过
     * @return  bool
    */
    public static function checkStaffAnniversaryPass (int $staffId, int $serial) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkStaffAnniversaryPass(["staffId" => $staffId, "serial" => $serial]);
    }
    /**
     * 已庆祝过的纪念日
     * @return  array
    */
    public static function getStaffAnniversaryHistory (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffAnniversaryHistory(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}