<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getProjectsByParams(array $params)
 * @method getProjectListByParams(array $params)
 */
class ThirdPartyProject {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (string $name) {
        return self::getClass()->create([
            "name" => $name,
        ]);
    }

    /**
     * update
     *
     * @param  int $id 记录id [ require true ]
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id, string $name) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * delete
     *
     * @param  array $ids 记录ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (array $ids) {
        return self::getClass()->delete([
            "ids" => $ids,
        ]);
    }

    /**
     * getProjects
     *
     * @param  string $name 名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProjects (string $name = '') {
        return self::getClass()->getProjects([
            "name" => $name,
        ]);
    }

    /**
     * getProjectList
     *
     * @param  string $name 名称 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProjectList (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProjectList([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'ThirdPartyProject');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'ThirdPartyProject');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}