<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addGroupByParams(array $params)
 * @method editGroupByParams(array $params)
 * @method deleteGroupByParams(array $params)
 * @method getGroupStaffIdsByGroupIdByParams(array $params)
 * @method getGroupIdsByStaffIdByParams(array $params)
 * @method getGroupIdsByStaffIdsByParams(array $params)
 * @method getGroupListByParams(array $params)
 * @method getGroupsByApplicationByParams(array $params)
 * @method getGroupsByGroupIdsByParams(array $params)
 * @method getGroupByGroupIdByParams(array $params)
 * @method getStaffIdsByRulesByParams(array $params)
 */
class Group {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * addGroup
     *
     * @param  string $name 组名 [ require true ]
     * @param  array $rules 规则组 [ require false ]
     * @param  array $includes 包含的staffIds [ require false ]
     * @param  array $excludes 排除的staffIds [ require false ]
     * @param  string $application 应用于 [ require true ]
     * @param  int $creator 创建人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addGroup (string $name, string $application, int $creator, array $rules = [], array $includes = [], array $excludes = []) {
        return self::getClass()->addGroup([
            "name" => $name,
            "application" => $application,
            "creator" => $creator,
            "rules" => $rules,
            "includes" => $includes,
            "excludes" => $excludes,
        ]);
    }

    /**
     * rules || includes || excludes 不传则删除原有
     *
     * @param  int $groupId 组id [ require true ]
     * @support  string $name 组名 [ require false ]
     * @support  array $rules 规则组 [ require false ]
     * @support  array $includes 包含的staffIds [ require false ]
     * @support  array $excludes 排除的staffIds [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editGroup (int $groupId) {
        return self::getClass()->editGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * deleteGroup
     *
     * @param  int $groupId 组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteGroup (int $groupId) {
        return self::getClass()->deleteGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * getGroupStaffIdsByGroupId
     *
     * @param  int $groupId 组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupStaffIdsByGroupId (int $groupId) {
        return self::getClass()->getGroupStaffIdsByGroupId([
            "groupId" => $groupId,
        ]);
    }

    /**
     * getGroupIdsByStaffId
     *
     * @param  int $staffId staff id [ require true ]
     * @param  string $application 应用于 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupIdsByStaffId (int $staffId, string $application) {
        return self::getClass()->getGroupIdsByStaffId([
            "staffId" => $staffId,
            "application" => $application,
        ]);
    }

    /**
     * getGroupIdsByStaffIds
     *
     * @param  array $staffIds staff ids [ require true ]
     * @param  string $application 应用于 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupIdsByStaffIds (array $staffIds, string $application) {
        return self::getClass()->getGroupIdsByStaffIds([
            "staffIds" => $staffIds,
            "application" => $application,
        ]);
    }

    /**
     * getGroupList
     *
     * @support  string $application 应用于 [ require false ]
     * @support  array $applications 应用于s [ require false ]
     * @param  bool $withStaffIds 包含伙伴ids [ require false ]
     * @support  array $groupIds 分组ids [ require false ]
     * @support  array $exceptGroupIds 分组ids [ require false ]
     * @support  string $nameMatch 名称匹配 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @param  int $page page [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupList (bool $withStaffIds = false, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getGroupList([
            "withStaffIds" => $withStaffIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getGroupsByApplication
     *
     * @support  string $application 应用于 [ require false ]
     * @support  array $applications 应用于s [ require false ]
     * @support  string $nameMatch 名称匹配 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupsByApplication () {
        return self::getClass()->getGroupsByApplication([
        ]);
    }

    /**
     * getGroupsByGroupIds
     *
     * @param  array $groupIds 组ids [ require true ]
     * @param  bool $withStaffIds 包含伙伴ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupsByGroupIds (array $groupIds, bool $withStaffIds = false) {
        return self::getClass()->getGroupsByGroupIds([
            "groupIds" => $groupIds,
            "withStaffIds" => $withStaffIds,
        ]);
    }

    /**
     * 获取分组详情
     *
     * @param  int $groupId 组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupByGroupId (int $groupId) {
        return self::getClass()->getGroupByGroupId([
            "groupId" => $groupId,
        ]);
    }

    /**
     * getStaffIdsByRules
     *
     * @param  array $rules 规则组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffIdsByRules (array $rules) {
        return self::getClass()->getStaffIdsByRules([
            "rules" => $rules,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Group');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Group');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}