<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getStaffsByParams(array $params)
 * @method getStaffListByParams(array $params)
 */
class ThirdPartyStaff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @param  int $projectId 项目id [ require true ]
     * @param  string $mobile 手机号 [ require true ]
     * @param  string $nickname 昵称 [ require true ]
     * @param  bool $needSync 是否需要同步 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $projectId, string $mobile, string $nickname, bool $needSync = false) {
        return self::getClass()->create([
            "projectId" => $projectId,
            "mobile" => $mobile,
            "nickname" => $nickname,
            "needSync" => $needSync,
        ]);
    }

    /**
     * update
     *
     * @param  int $id 记录id [ require true ]
     * @param  int $projectId 项目id [ require false ]
     * @param  string $mobile 手机号 [ require false ]
     * @param  string $nickname 昵称 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id, int $projectId = 0, string $mobile = '', string $nickname = '') {
        return self::getClass()->update([
            "id" => $id,
            "projectId" => $projectId,
            "mobile" => $mobile,
            "nickname" => $nickname,
        ]);
    }

    /**
     * delete
     *
     * @param  array $ids 记录ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (array $ids) {
        return self::getClass()->delete([
            "ids" => $ids,
        ]);
    }

    /**
     * getStaffs
     *
     * @support  array $ids 记录ids [ require false ]
     * @support  array $projectIds 项目ids [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $nickname 昵称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffs () {
        return self::getClass()->getStaffs([
        ]);
    }

    /**
     * getStaffList
     *
     * @support  array $projectIds 项目ids [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $nickname 昵称 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'ThirdPartyStaff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'ThirdPartyStaff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}