<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method onDingTalkLoginByParams(array $params)
 * @method syncDingTalkStaffJobInfoByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 钉钉登录时进行更新
     *
     * @support  string $userid 钉钉用户ID [ require true ]
     * @support  string $name 钉钉昵称 require false
     * @support  string $tel 座机 require false
     * @support  string $name 钉钉用户名 require false
     * @support  string $mobile 手机 require false
     * @support  string $email 邮箱 require false
     * @support  string $dingId 钉钉全局ID require false
     * @support  string $position 职位 require false
     * @param  string $jobnumber 工号 [ require true ]
     * @support  string $avatar 头像 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function onDingTalkLogin (string $jobnumber) {
        return self::getClass()->onDingTalkLogin([
            "jobnumber" => $jobnumber,
        ]);
    }

    /**
     * 同步钉钉伙伴职位信息
     *
     * @param  array $staffDingIds 伙伴钉钉ids [ require true ]
     * @param  string $newPosition 新的职位名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncDingTalkStaffJobInfo (array $staffDingIds, string $newPosition) {
        return self::getClass()->syncDingTalkStaffJobInfo([
            "staffDingIds" => $staffDingIds,
            "newPosition" => $newPosition,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}