<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method departmentSetByParams(array $params)
 * @method getSettingByParams(array $params)
 */
class Setting {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 部门配置
     *
     * @param  array $content 配置信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function departmentSet (array $content) {
        return self::getClass()->departmentSet([
            "content" => $content,
        ]);
    }

    /**
     * getSetting
     *
     * @param  string $group_name 配置组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSetting (string $group_name) {
        return self::getClass()->getSetting([
            "group_name" => $group_name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Setting');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Setting');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}