<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserTagsByParams(array $params)
 * @method getUserTagContentByTagNameByParams(array $params)
 * @method getUserTagContentsByTagNamesByParams(array $params)
 * @method getUsersTagContentsByTagNameByParams(array $params)
 * @method setUserTagByParams(array $params)
 * @method getStaffInfoByTagsByParams(array $params)
 */
class StaffTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过伙伴ID获取单个伙伴信息
     *
     * @param  int $staffId 伙伴ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTags (int $staffId) {
        return self::getClass()->getUserTags([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 通过伙伴ID和标记名称获取单个标记信息
     *
     * @param  int $staffId 伙伴ID [Original type uint] [ require true ]
     * @param  string $tagName 标记名称 [ require true ]
     * @param  bool $withStaffInfo 包含伙伴信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTagContentByTagName (int $staffId, string $tagName, bool $withStaffInfo = false) {
        return self::getClass()->getUserTagContentByTagName([
            "staffId" => $staffId,
            "tagName" => $tagName,
            "withStaffInfo" => $withStaffInfo,
        ]);
    }

    /**
     * 通过伙伴ID和多个标记名称获取多个标记信息
     *
     * @param  int $staffId 伙伴ID [Original type uint] [ require true ]
     * @param  array $tagNames 标记名称 [Original type array&lt;string&gt;] [ require true ]
     * @param  bool $withStaffInfo 包含伙伴信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTagContentsByTagNames (int $staffId, array $tagNames, bool $withStaffInfo = false) {
        return self::getClass()->getUserTagContentsByTagNames([
            "staffId" => $staffId,
            "tagNames" => $tagNames,
            "withStaffInfo" => $withStaffInfo,
        ]);
    }

    /**
     * 通过多个伙伴ID和标记名称获取多个标记信息
     *
     * @param  array $staffIds 伙伴ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  string $tagName 标记名称 [ require true ]
     * @param  bool $withStaffInfo 包含伙伴信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUsersTagContentsByTagName (array $staffIds, string $tagName, bool $withStaffInfo = false) {
        return self::getClass()->getUsersTagContentsByTagName([
            "staffIds" => $staffIds,
            "tagName" => $tagName,
            "withStaffInfo" => $withStaffInfo,
        ]);
    }

    /**
     * 设置伙伴标记
     *
     * @param  int $staffId 伙伴ID [Original type uint] [ require true ]
     * @param  string $tagName 标记名称 [ require true ]
     * @param  mixed $tagContent 标记内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserTag (int $staffId, string $tagName, mixed $tagContent) {
        return self::getClass()->setUserTag([
            "staffId" => $staffId,
            "tagName" => $tagName,
            "tagContent" => $tagContent,
        ]);
    }

    /**
     * 通过标签获取员工信息
     *
     * @param  array $tagNames 标签名称 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  bool $isAll 是否需要分页 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfoByTags (array $tagNames, int $page = 1, int $pageSize = 10, bool $isAll = false) {
        return self::getClass()->getStaffInfoByTags([
            "tagNames" => $tagNames,
            "page" => $page,
            "pageSize" => $pageSize,
            "isAll" => $isAll,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'StaffTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'StaffTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}