<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addGroupByParams(array $params)
 * @method editGroupByParams(array $params)
 * @method deleteGroupByParams(array $params)
 * @method getGroupStaffIdsByGroupIdByParams(array $params)
 * @method getGroupsWithStaffsByGroupIdsByParams(array $params)
 * @method getGroupIdsByStaffIdByParams(array $params)
 * @method getGroupIdsByStaffIdsByParams(array $params)
 * @method getGroupListByParams(array $params)
 */
class Group {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * addGroup
     *
     * @param  string $name 组名 [ require true ]
     * @param  array $rules 规则组 [ require true ]
     * @param  array $includes 包含的staffIds [ require true ]
     * @param  array $excludes 排除的staffIds [ require true ]
     * @param  string $application 应用于 [ require true ]
     * @param  int $creator 创建人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addGroup (string $name, string $application, int $creator, array $rules = [], array $includes = [], array $excludes = []) {
        return self::getClass()->addGroup([
            "name" => $name,
            "application" => $application,
            "creator" => $creator,
            "rules" => $rules,
            "includes" => $includes,
            "excludes" => $excludes,
        ]);
    }

    /**
     * rules || includes || excludes 不传则删除原有
     *
     * @param  int $groupId 组id [Original type uint] [ require true ]
     * @support  string $name 组名 
     * @support  array $rules 规则组 
     * @support  array $includes 包含的staffIds 
     * @support  array $excludes 排除的staffIds 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editGroup (int $groupId) {
        return self::getClass()->editGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * deleteGroup
     *
     * @param  int $groupId 组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteGroup (int $groupId) {
        return self::getClass()->deleteGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * getGroupStaffIdsByGroupId
     *
     * @param  int $groupId 组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffIdsByGroupId (int $groupId) {
        return self::getClass()->getGroupStaffIdsByGroupId([
            "groupId" => $groupId,
        ]);
    }

    /**
     * getGroupsWithStaffsByGroupIds
     *
     * @param  array $groupIds 组ids [ require true ]
     * @param  bool $withStaffIds 包含伙伴ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupsWithStaffsByGroupIds (array $groupIds, bool $withStaffIds = false) {
        return self::getClass()->getGroupsWithStaffsByGroupIds([
            "groupIds" => $groupIds,
            "withStaffIds" => $withStaffIds,
        ]);
    }

    /**
     * getGroupIdsByStaffId
     *
     * @param  int $staffId staff id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupIdsByStaffId (int $staffId) {
        return self::getClass()->getGroupIdsByStaffId([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getGroupIdsByStaffIds
     *
     * @param  array $staffIds staff ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupIdsByStaffIds (array $staffIds) {
        return self::getClass()->getGroupIdsByStaffIds([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getGroupList
     *
     * @param  string $application 应用于 [ require true ]
     * @param  bool $withStaffIds 包含伙伴ids [ require true ]
     * @support  string $name 名称 
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupList (string $application, bool $withStaffIds = false, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getGroupList([
            "application" => $application,
            "withStaffIds" => $withStaffIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Group');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Group');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}