<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createDepartmentByParams(array $params)
 * @method editDepartmentByParams(array $params)
 * @method delDepartmentByParams(array $params)
 * @method createDepTypeByParams(array $params)
 * @method delDepTypeByParams(array $params)
 * @method editDepTypeByParams(array $params)
 * @method getDepTypeByParams(array $params)
 * @method addPositionByParams(array $params)
 * @method createPositionByParams(array $params)
 * @method editPositionNameByParams(array $params)
 * @method delPositionByParams(array $params)
 * @method getDepartmentDetailByParams(array $params)
 * @method getDepartmentByTypeByParams(array $params)
 * @method getPositionDetailByParams(array $params)
 * @method getAreaTranslateByParams(array $params)
 * @method getStoreByDeptIdByParams(array $params)
 * @method getDepartmentByStoreIdsByParams(array $params)
 * @method getDepartmentByParams(array $params)
 * @method getFamilyDepartmentByParams(array $params)
 * @method getPositionByParams(array $params)
 * @method searchByLevelByParams(array $params)
 * @method onDingDepartmentUpdateByParams(array $params)
 * @method departmentTreeByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增部门
     *
     * @param  int $parent 父级id [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  string $name 架构名称 [ require true ]
     * @param  int $depType 部门类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createDepartment (int $parent, int $store_id, string $name, int $depType = 0) {
        return self::getClass()->createDepartment([
            "parent" => $parent,
            "store_id" => $store_id,
            "name" => $name,
            "depType" => $depType,
        ]);
    }

    /**
     * 非必填参数不传则保持原样
     *
     * @param  int $id 架构id [ require true ]
     * @support  string $name 架构名称 
     * @support  int $store_id 门店id 
     * @support  int $parent 父级id 
     * @support  int $dep_type 部门类型 
     * @support  int $dingManagerStaffId 部门主管(主管必须为该部门下的伙伴) 
     * @throws  \Exception
     * @return  array
     */
    public static function editDepartment (int $id) {
        return self::getClass()->editDepartment([
            "id" => $id,
        ]);
    }

    /**
     * 删除架构
     *
     * @param  int $id 架构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delDepartment (int $id) {
        return self::getClass()->delDepartment([
            "id" => $id,
        ]);
    }

    /**
     * 创建部门分类
     *
     * @param  string $name 分类名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDepType (string $name) {
        return self::getClass()->createDepType([
            "name" => $name,
        ]);
    }

    /**
     * 删除分类名称
     *
     * @param  int $depTypeId 分类id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delDepType (int $depTypeId) {
        return self::getClass()->delDepType([
            "depTypeId" => $depTypeId,
        ]);
    }

    /**
     * 修改分类名称
     *
     * @param  int $depTypeId 分类id [ require true ]
     * @param  string $name 分类名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editDepType (int $depTypeId, string $name) {
        return self::getClass()->editDepType([
            "depTypeId" => $depTypeId,
            "name" => $name,
        ]);
    }

    /**
     * 查找分类名称
     *
     * @param  array $depTypeIds 分类ids [ require true ]
     * @param  string $name 名称[可定义%进行模糊查询] [ require true ]
     * @param  bool $withDel 是否包含已删数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepType (array $depTypeIds = [], string $name = '', bool $withDel = false) {
        return self::getClass()->getDepType([
            "depTypeIds" => $depTypeIds,
            "name" => $name,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 新增职位
     * @deprecated
     *
     * @param  int $id 部门id [ require true ]
     * @param  string $name 部门名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPosition (int $id, string $name) {
        return self::getClass()->addPosition([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 新增职位
     *
     * @param  string $name 部门名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPosition (string $name) {
        return self::getClass()->createPosition([
            "name" => $name,
        ]);
    }

    /**
     * 修改职位名称
     *
     * @param  int $id 职位id [ require true ]
     * @param  string $name 职位名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editPositionName (int $id, string $name = '') {
        return self::getClass()->editPositionName([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 删除职位
     *
     * @param  int $id 部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delPosition (int $id) {
        return self::getClass()->delPosition([
            "id" => $id,
        ]);
    }

    /**
     * 根据部门ID获取部门详情
     *
     * @param  array $deptIds 部门IDS [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDepartmentDetail (array $deptIds) {
        return self::getClass()->getDepartmentDetail([
            "deptIds" => $deptIds,
        ]);
    }

    /**
     * 根据部门分类id获取部门详情
     *
     * @param  int $typeId 分类id [ require true ]
     * @param  bool $withDel 是否包含删除数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDepartmentByType (int $typeId, bool $withDel = false) {
        return self::getClass()->getDepartmentByType([
            "typeId" => $typeId,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 根据职位ID获取职位详情
     *
     * @param  array $positionIds 职位ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPositionDetail (array $positionIds) {
        return self::getClass()->getPositionDetail([
            "positionIds" => $positionIds,
        ]);
    }

    /**
     * 转换区域名称
     *
     * @param  array $deptIds 部门IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaTranslate (array $deptIds) {
        return self::getClass()->getAreaTranslate([
            "deptIds" => $deptIds,
        ]);
    }

    /**
     * 根据部门ID获取店铺ID
     *
     * @param  int $deptId 部门ID [ require true ]
     * @param  bool $withDel 是否需要已删除数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByDeptId (int $deptId, bool $withDel = false) {
        return self::getClass()->getStoreByDeptId([
            "deptId" => $deptId,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 根据门店ids获取部门
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentByStoreIds (array $storeIds) {
        return self::getClass()->getDepartmentByStoreIds([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取部门列表
     *
     * @param  string $name 部门名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDepartment (string $name = '') {
        return self::getClass()->getDepartment([
            "name" => $name,
        ]);
    }

    /**
     * 获取部门所有关系部门
     *
     * @param  int $deptId 部门ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFamilyDepartment (int $deptId) {
        return self::getClass()->getFamilyDepartment([
            "deptId" => $deptId,
        ]);
    }

    /**
     * 获取岗位列表 (模糊查询匹配模式调用方自己处理)
     *
     * @param  string $name 职位名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPosition (string $name = '') {
        return self::getClass()->getPosition([
            "name" => $name,
        ]);
    }

    /**
     * 按父级id和level搜索信息
     *
     * @param  int $level level等级 [ require true ]
     * @param  int $parent_id 父级id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchByLevel (int $level = NULL, int $parent_id = NULL) {
        return self::getClass()->searchByLevel([
            "level" => $level,
            "parent_id" => $parent_id,
        ]);
    }

    /**
     * 处理钉钉部门修改
     *
     * @param  array $DeptId 更新的部门 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onDingDepartmentUpdate (array $DeptId) {
        return self::getClass()->onDingDepartmentUpdate([
            "DeptId" => $DeptId,
        ]);
    }

    /**
     * 部门树
     *
     * @support  int $beginDepartmentId 部门树根节点id 
     * @param  bool $withDel 包含已删除部门 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function departmentTree (bool $withDel = false) {
        return self::getClass()->departmentTree([
            "withDel" => $withDel,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}