<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createGroupByParams(array $params)
 * @method getGroupByParams(array $params)
 * @method editGroupByParams(array $params)
 * @method getGroupsByParams(array $params)
 * @method getGroupListByParams(array $params)
 * @method delGroupByParams(array $params)
 * @method getStaffByGroupIdByParams(array $params)
 * @method getStaffByGroupIdsByParams(array $params)
 * @method queryGroupByDepartmentByParams(array $params)
 * @method queryGroupByJobByParams(array $params)
 * @method queryGroupByStaffIdByParams(array $params)
 * @method queryGroupIdByStaffIdsByParams(array $params)
 * @method addStaffsToGroupByParams(array $params)
 * @method delStaffFromGroupByParams(array $params)
 */
class Collection {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建分组
     *
     * @param  string $groupName 分组名称 [ require true ]
     * @param  string $application 应用 [ require true ]
     * @param  string $matchPattern 匹配模式 [ require true ]
     * @param  array $groupTypes 分组类型 [ require true ]
     * @param  int $createStaff 分组创建人 [ require true ]
     * @support  array $extraStaff 额外用户 
     * @support  array $excludeStaff 去除用户 
     * @support  array $extend 额外信息 
     * @support  string $desc 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createGroup (string $groupName, string $application, string $matchPattern, array $groupTypes, int $createStaff) {
        return self::getClass()->createGroup([
            "groupName" => $groupName,
            "application" => $application,
            "matchPattern" => $matchPattern,
            "groupTypes" => $groupTypes,
            "createStaff" => $createStaff,
        ]);
    }

    /**
     * 获取分组信息
     *
     * @param  int $groupId 分组ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroup (int $groupId) {
        return self::getClass()->getGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 修改分组
     *
     * @param  int $groupId 分组ID [ require true ]
     * @support  int $createStaff 创建人 
     * @support  string $application 应用 
     * @support  string $matchPattern 匹配模式 
     * @support  string $groupName 分组名称 
     * @support  array $groupTypes 分组类型 
     * @support  array $extraStaff 额外添加人 
     * @support  array $excludeStaff 排除的人 
     * @support  array $extend 其他配置参数 
     * @support  string $desc 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editGroup (int $groupId) {
        return self::getClass()->editGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 获取分组列表(不带分页)
     *
     * @param  string $application 应用 [ require true ]
     * @param  string $groupName 分组名称 [ require true ]
     * @param  array $groupIds 分组ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroups (string $application = '', array $groupIds = [], string $groupName = '') {
        return self::getClass()->getGroups([
            "application" => $application,
            "groupIds" => $groupIds,
            "groupName" => $groupName,
        ]);
    }

    /**
     * 获取分组列表(带分页)
     *
     * @param  string $application 应用 [ require true ]
     * @param  string $groupName 分组名称 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  array $groupIds 分组ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupList (string $application = '', array $groupIds = [], string $groupName = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getGroupList([
            "application" => $application,
            "groupIds" => $groupIds,
            "groupName" => $groupName,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除分组
     *
     * @param  int $groupId 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delGroup (int $groupId) {
        return self::getClass()->delGroup([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 通过groupId获取staff信息
     *
     * @param  int $groupId 分组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffByGroupId (int $groupId) {
        return self::getClass()->getStaffByGroupId([
            "groupId" => $groupId,
        ]);
    }

    /**
     * 通过groupIds获取staff信息
     *
     * @param  array $groupIds 分组ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffByGroupIds (array $groupIds) {
        return self::getClass()->getStaffByGroupIds([
            "groupIds" => $groupIds,
        ]);
    }

    /**
     * 查询部门所在组
     *
     * @param  int $departmentId 部门id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryGroupByDepartment (int $departmentId) {
        return self::getClass()->queryGroupByDepartment([
            "departmentId" => $departmentId,
        ]);
    }

    /**
     * 查询岗位所在组
     *
     * @param  int $job_id 岗位id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryGroupByJob (int $job_id) {
        return self::getClass()->queryGroupByJob([
            "job_id" => $job_id,
        ]);
    }

    /**
     * 根据员工id查询所在组
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  string $application 员工组来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryGroupByStaffId (int $staffId, string $application = '') {
        return self::getClass()->queryGroupByStaffId([
            "staffId" => $staffId,
            "application" => $application,
        ]);
    }

    /**
     * 根据员工ids查询所在组信息
     *
     * @param  array $staffIds 员工ids [ require true ]
     * @support  bool $needAll 获取全部数据 
     * @throws  \Exception
     * @return  array
     */
    public static function queryGroupIdByStaffIds (array $staffIds) {
        return self::getClass()->queryGroupIdByStaffIds([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 添加用户到组中
     *
     * @param  int $groupId 分组ID [ require true ]
     * @param  array $staffIds 员工IDs [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaffsToGroup (int $groupId, array $staffIds) {
        return self::getClass()->addStaffsToGroup([
            "groupId" => $groupId,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 从组中删除用户
     *
     * @param  array $staffIds 伙伴id [ require true ]
     * @param  int $groupId 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delStaffFromGroup (int $groupId, array $staffIds) {
        return self::getClass()->delStaffFromGroup([
            "groupId" => $groupId,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Collection');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Collection');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}