<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createGroupByParams(array $params)
 * @method groupListByParams(array $params)
 * @method delGroupByParams(array $params)
 * @method editGroupByParams(array $params)
 * @method getStaffIdByGroupIdsByParams(array $params)
 * @method getStaffByGroupIdByParams(array $params)
 * @method getStaffDetailByGroupIdByParams(array $params)
 * @method queryGroupByDepartmentByParams(array $params)
 * @method queryGroupByJobByParams(array $params)
 * @method getGroupIdByStaffIdsByParams(array $params)
 * @method queryGroupByPersonByParams(array $params)
 * @method addStaffToGroupsByParams(array $params)
 * @method addStaffsToGroupByParams(array $params)
 * @method delStaffFromGroupByParams(array $params)
 * @method getGroupDetailByParams(array $params)
 */
class Groups {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建分组
     *
     * @param  string $groupName 分组名称 [ require true ]
     * @param  string $application 应用 [ require true ]
     * @param  int $groupType 分组类型 [ require true ]
     * @param  int $createStaff 分组创建人 [ require true ]
     * @param  array $typeKey 分组类型键 [ require true ]
     * @param  array $extraStaff 额外用户 [ require true ]
     * @param  array $excludeStaff 去除用户 [ require true ]
     * @param  array $extend 额外信息 [ require true ]
     * @param  string $desc 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createGroup (string $groupName, string $application, int $groupType, int $createStaff, array $typeKey = [], array $extraStaff = [], array $excludeStaff = [], array $extend = [], string $desc = '') {
        return self::getClass()->createGroup([
            "groupName" => $groupName,
            "application" => $application,
            "groupType" => $groupType,
            "createStaff" => $createStaff,
            "typeKey" => $typeKey,
            "extraStaff" => $extraStaff,
            "excludeStaff" => $excludeStaff,
            "extend" => $extend,
            "desc" => $desc,
        ]);
    }

    /**
     * 获取分组列表
     *
     * @param  string $application 应用 [ require true ]
     * @param  int $groupType 分组类型 [ require true ]
     * @param  string $groupName 分组名称 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  array $groupIds 分组ids [ require true ]
     * @param  bool $isAll 是否获取所有参数 [ require true ]
     * @param  bool $needRelation 是否需要关联staff [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function groupList (string $application = '', int $groupType = 0, array $groupIds = [], string $groupName = '', bool $isAll = false, int $page = 1, int $pageSize = 10, bool $needRelation = true) {
        return self::getClass()->groupList([
            "application" => $application,
            "groupType" => $groupType,
            "groupIds" => $groupIds,
            "groupName" => $groupName,
            "isAll" => $isAll,
            "page" => $page,
            "pageSize" => $pageSize,
            "needRelation" => $needRelation,
        ]);
    }

    /**
     * 删除分组
     *
     * @param  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delGroup (int $id) {
        return self::getClass()->delGroup([
            "id" => $id,
        ]);
    }

    /**
     * 修改分组
     *
     * @param  int $groupId 分组ID [ require true ]
     * @param  int $createStaff 创建人 [ require true ]
     * @param  string $application 应用 [ require true ]
     * @param  string $groupName 分组名称 [ require true ]
     * @param  int $groupType 分组类型 [ require true ]
     * @param  array $typeKey 类型键 [ require true ]
     * @param  array $extraStaff 额外添加人 [ require true ]
     * @param  array $excludeStaff 排除的人 [ require true ]
     * @param  array $extend 其他配置参数 [ require true ]
     * @param  string $desc 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editGroup (int $groupId, int $createStaff = 0, string $application = '', string $groupName = '', int $groupType = 0, array $typeKey = [], array $extraStaff = [], array $excludeStaff = [], array $extend = [], string $desc = '') {
        return self::getClass()->editGroup([
            "groupId" => $groupId,
            "createStaff" => $createStaff,
            "application" => $application,
            "groupName" => $groupName,
            "groupType" => $groupType,
            "typeKey" => $typeKey,
            "extraStaff" => $extraStaff,
            "excludeStaff" => $excludeStaff,
            "extend" => $extend,
            "desc" => $desc,
        ]);
    }

    /**
     * 根据组ids查询所在组staffId
     *
     * @param  array $group_ids 组ids [Original type array&lt;int&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdByGroupIds (array $group_ids) {
        return self::getClass()->getStaffIdByGroupIds([
            "group_ids" => $group_ids,
        ]);
    }

    /**
     * 根据分组id查询对应伙伴列表
     *
     * @param  array $groupIds 分组Id [ require true ]
     * @param  bool $groupBy 是否对结果分组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffByGroupId (array $groupIds, bool $groupBy = false) {
        return self::getClass()->getStaffByGroupId([
            "groupIds" => $groupIds,
            "groupBy" => $groupBy,
        ]);
    }

    /**
     * 根据分组ID获取对应伙伴详情
     *
     * @param  array $groupIds 分组ids [ require true ]
     * @param  int $page 分页 [ require true ]
     * @param  int $pageSize 页码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffDetailByGroupId (array $groupIds, int $page = 1, int $pageSize = 15) {
        return self::getClass()->getStaffDetailByGroupId([
            "groupIds" => $groupIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 查询部门所在组
     *
     * @param  int $department_id 部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryGroupByDepartment (int $department_id) {
        return self::getClass()->queryGroupByDepartment([
            "department_id" => $department_id,
        ]);
    }

    /**
     * 查询岗位所在组
     *
     * @param  int $job_id 岗位id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryGroupByJob (int $job_id) {
        return self::getClass()->queryGroupByJob([
            "job_id" => $job_id,
        ]);
    }

    /**
     * 根据员工ids查询所在组信息
     *
     * @param  array $staff_ids 员工ids [ require true ]
     * @param  bool $needAll 获取全部数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupIdByStaffIds (array $staff_ids, bool $needAll = false) {
        return self::getClass()->getGroupIdByStaffIds([
            "staff_ids" => $staff_ids,
            "needAll" => $needAll,
        ]);
    }

    /**
     * 根据员工id查询所在组
     *
     * @param  int $staff_id 员工id [ require true ]
     * @param  string $application 员工组来源 [ require true ]
     * @param  bool $needAll 是否需要完整数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryGroupByPerson (int $staff_id, string $application = '', bool $needAll = false) {
        return self::getClass()->queryGroupByPerson([
            "staff_id" => $staff_id,
            "application" => $application,
            "needAll" => $needAll,
        ]);
    }

    /**
     * 添加用户到多个组中
     *
     * @param  array $groupIds 分组ids [ require true ]
     * @param  string $staffId 伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaffToGroups (array $groupIds, string $staffId) {
        return self::getClass()->addStaffToGroups([
            "groupIds" => $groupIds,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 添加用户到组中
     *
     * @param  int $groupId 分组ID [ require true ]
     * @param  array $staffIds 员工IDs [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaffsToGroup (int $groupId, array $staffIds) {
        return self::getClass()->addStaffsToGroup([
            "groupId" => $groupId,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 从组中删除用户
     *
     * @param  array $staffIds 伙伴id [ require true ]
     * @param  int $groupId 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delStaffFromGroup (int $groupId, array $staffIds) {
        return self::getClass()->delStaffFromGroup([
            "groupId" => $groupId,
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 根据组ID获取组详情
     *
     * @param  int $groupId 组ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupDetail (int $groupId) {
        return self::getClass()->getGroupDetail([
            "groupId" => $groupId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Groups');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Groups');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}