<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByDeptByParams(array $params)
 * @method getStaffListByJobsByParams(array $params)
 * @method getStaffCountByJobsByParams(array $params)
 * @method getStaffListByDeptsByParams(array $params)
 * @method getStaffListByStoreByParams(array $params)
 * @method getAllStaffsByStoreByParams(array $params)
 * @method getStaffByIdByParams(array $params)
 * @method getStaffByBatchByParams(array $params)
 * @method getStaffByParams(array $params)
 * @method getStaffNameByIdsByParams(array $params)
 * @method getStaffIdsByRealNameByParams(array $params)
 * @method getStaffIdsByRealOrNickNameByParams(array $params)
 * @method getStaffIdsByNickNameByParams(array $params)
 * @method getStaffInfoByIdsByParams(array $params)
 * @method getDingdingUidByParams(array $params)
 * @method addStaffByParams(array $params)
 * @method addStaffWithAutoIncrementByParams(array $params)
 * @method updateStaffByDingTalkReqByParams(array $params)
 * @method completeExceptionDingTalkCreateStaffByParams(array $params)
 * @method forceRemoveStaffByParams(array $params)
 * @method editStaffInfoByParams(array $params)
 * @method staffResignationByParams(array $params)
 * @method staffUnResignationByParams(array $params)
 * @method getStaffListByManageStoreByParams(array $params)
 * @method queryDeptManagerByStaffByParams(array $params)
 * @method getStaffAllDepParentByParams(array $params)
 * @method getStaffDetailByDingIdByParams(array $params)
 * @method createStaffPluralismByParams(array $params)
 * @method handleStaffPluralismByParams(array $params)
 * @method removeStaffAllPluralismByParams(array $params)
 * @method staffPluralismListByParams(array $params)
 * @method countPluralismNumByParams(array $params)
 * @method getStaffPluralismDetailByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [分页]通过部门获取伙伴列表
     *
     * @param  int $dept 部门ID [Original type uint] [ require true ]
     * @param  int $position 职位 [Original type uint] [ require true ]
     * @param  int $count 获取记录条数 [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  array $staff_ids 员工id [ require true ]
     * @param  int $state 是否在职 1是 2否 3全部 [ require true ]
     * @param  string $level 职级 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffListByDept (int $dept = 0, int $position = NULL, int $count = 10, int $page = 1, array $staff_ids = [], int $state = 1, string $level = '') {
        return self::getClass()->getStaffListByDept([
            "dept" => $dept,
            "position" => $position,
            "count" => $count,
            "page" => $page,
            "staff_ids" => $staff_ids,
            "state" => $state,
            "level" => $level,
        ]);
    }

    /**
     * 根据批量职位id获取员工列表
     *
     * @param  array $job_ids 职位id [ require true ]
     * @param  bool $with_staff 是否需要staff信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffListByJobs (array $job_ids, bool $with_staff = true) {
        return self::getClass()->getStaffListByJobs([
            "job_ids" => $job_ids,
            "with_staff" => $with_staff,
        ]);
    }

    /**
     * 根据job获取伙伴数量
     *
     * @param  array $jobIds 职位id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffCountByJobs (array $jobIds) {
        return self::getClass()->getStaffCountByJobs([
            "jobIds" => $jobIds,
        ]);
    }

    /**
     * 根据批量部门id获取员工列表
     *
     * @param  array $depts 部门ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffListByDepts (array $depts) {
        return self::getClass()->getStaffListByDepts([
            "depts" => $depts,
        ]);
    }

    /**
     * [分页]通过门店获取伙伴列表
     *
     * @param  int $store 门店ID [Original type uint] [ require true ]
     * @param  int $position 职位 [Original type uint] [ require true ]
     * @param  int $count 获取记录条数 [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  array $staff_ids 员工id [ require true ]
     * @param  int $state 是否在职 1是 2否 3全部 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffListByStore (int $store, int $position = NULL, int $count = 10, int $page = 1, array $staff_ids = [], int $state = 1) {
        return self::getClass()->getStaffListByStore([
            "store" => $store,
            "position" => $position,
            "count" => $count,
            "page" => $page,
            "staff_ids" => $staff_ids,
            "state" => $state,
        ]);
    }

    /**
     * 获取某个门店所有伙伴
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $staffType 伙伴职位Alias [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllStaffsByStore (int $storeId, string $staffType) {
        return self::getClass()->getAllStaffsByStore([
            "storeId" => $storeId,
            "staffType" => $staffType,
        ]);
    }

    /**
     * 通过伙伴ID获取单个伙伴信息
     *
     * @param  int $staffId 伙伴ID [Original type uint] [ require true ]
     * @param  int $includDelete 是否包含已删除 1:要 0：不要 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffById (int $staffId, int $includDelete = 0) {
        return self::getClass()->getStaffById([
            "staffId" => $staffId,
            "includDelete" => $includDelete,
        ]);
    }

    /**
     * [批量] 根据伙伴id查询伙伴信息
     *
     * @param  array $staff_ids 伙伴ID [ require true ]
     * @param  bool $with_delete 是否包含软删除 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffByBatch (array $staff_ids, bool $with_delete = false) {
        return self::getClass()->getStaffByBatch([
            "staff_ids" => $staff_ids,
            "with_delete" => $with_delete,
        ]);
    }

    /**
     * 查询伙伴列表 [之前方法会逐渐废弃]
     *
     * @param  array $deptIds 部门ids [ require true ]
     * @param  array $positionIds 职位ids [ require true ]
     * @param  string $phone 伙伴手机号 [ require true ]
     * @param  array $storeId 门店ids [ require true ]
     * @param  array $staffIds 员工ids [ require true ]
     * @param  string $level 职级 [ require true ]
     * @param  string $name 姓名 [ require true ]
     * @param  string $nickname 昵称 [ require true ]
     * @param  bool $withDel 是否需要已删除数据 [ require true ]
     * @param  bool $onlyDel 是否只需要已删除的数据 [ require true ]
     * @param  array $exceptStaffIds 排除某些伙伴ids [ require true ]
     * @param  string $entryStartTime 入职开始时间 [ require true ]
     * @param  string $entryEndTime 入职结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  bool $isAll 是否需要分页 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaff (array $deptIds = [], array $positionIds = [], array $storeId = [], array $staffIds = [], string $level = '', string $name = '', string $nickname = '', bool $withDel = false, array $exceptStaffIds = [], bool $onlyDel = false, string $phone = '', string $entryStartTime = '', string $entryEndTime = '', int $page = 1, int $pageSize = 15, bool $isAll = false) {
        return self::getClass()->getStaff([
            "deptIds" => $deptIds,
            "positionIds" => $positionIds,
            "storeId" => $storeId,
            "staffIds" => $staffIds,
            "level" => $level,
            "name" => $name,
            "nickname" => $nickname,
            "withDel" => $withDel,
            "exceptStaffIds" => $exceptStaffIds,
            "onlyDel" => $onlyDel,
            "phone" => $phone,
            "entryStartTime" => $entryStartTime,
            "entryEndTime" => $entryEndTime,
            "page" => $page,
            "pageSize" => $pageSize,
            "isAll" => $isAll,
        ]);
    }

    /**
     * 通过多个伙伴ID获取伙伴姓名
     *
     * @param  array $staffIds 多个伙伴ID [Original type array&lt;int&gt;] [ require true ]
     * @param  bool $withDelete 是否需要软删除数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffNameByIds (array $staffIds, bool $withDelete = false) {
        return self::getClass()->getStaffNameByIds([
            "staffIds" => $staffIds,
            "withDelete" => $withDelete,
        ]);
    }

    /**
     * 通过伙伴姓名获得可能的工号
     *
     * @param  string $staffName 伙伴姓名 [ require true ]
     * @param  bool $isLike 是否是模糊查询 [ require true ]
     * @param  bool $withDel 是否查询已离职用户 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdsByRealName (string $staffName, bool $isLike = false, bool $withDel = false) {
        return self::getClass()->getStaffIdsByRealName([
            "staffName" => $staffName,
            "isLike" => $isLike,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     *
     * @param  string $staffName 伙伴姓名 [ require true ]
     * @param  bool $isLike 是否是模糊查询 [ require true ]
     * @param  bool $getAll 是否获取所有字段 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdsByRealOrNickName (string $staffName, bool $isLike = false, bool $getAll = false) {
        return self::getClass()->getStaffIdsByRealOrNickName([
            "staffName" => $staffName,
            "isLike" => $isLike,
            "getAll" => $getAll,
        ]);
    }

    /**
     * 通过伙伴花名获得可能的工号
     *
     * @param  string $staffName 伙伴花名 [ require true ]
     * @param  bool $isLike 是否是模糊查询 [ require true ]
     * @param  bool $withDel 是否包含删除 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdsByNickName (string $staffName, bool $isLike = false, bool $withDel = false) {
        return self::getClass()->getStaffIdsByNickName([
            "staffName" => $staffName,
            "isLike" => $isLike,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 通过多个伙伴ID获取伙伴姓名
     *
     * @param  array $staffIds 多个伙伴ID [Original type array&lt;int&gt;] [ require true ]
     * @param  bool $withDel 是否包含删除 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfoByIds (array $staffIds, bool $withDel = false) {
        return self::getClass()->getStaffInfoByIds([
            "staffIds" => $staffIds,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 根据staff_id 换区dingding uid
     *
     * @param  array $staff_ids 伙伴id集合 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDingdingUid (array $staff_ids) {
        return self::getClass()->getDingdingUid([
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * 新增伙伴
     * @deprecated
     *
     * @param  string $name 姓名 [ require true ]
     * @param  int $id id [ require true ]
     * @param  string $dingding_uid 钉钉uid [ require true ]
     * @param  string $nickname 花名 [ require true ]
     * @param  int $department_id 部门id [ require true ]
     * @param  int $job_id 职位id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  int $level level [ require true ]
     * @param  string $entry_at 入职时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaff (int $id, string $name, int $department_id, int $job_id, string $phone, string $dingding_uid, int $level, string $entry_at, string $nickname = '') {
        return self::getClass()->addStaff([
            "id" => $id,
            "name" => $name,
            "department_id" => $department_id,
            "job_id" => $job_id,
            "phone" => $phone,
            "dingding_uid" => $dingding_uid,
            "level" => $level,
            "entry_at" => $entry_at,
            "nickname" => $nickname,
        ]);
    }

    /**
     * 新增伙伴（自动创建主键）
     *
     * @param  string $name 姓名 [ require true ]
     * @param  string $nickname 花名 [ require true ]
     * @param  int $department_id 部门id [ require true ]
     * @param  int $job_id 职位id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  int $level level [ require true ]
     * @param  string $entry_at 入职时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaffWithAutoIncrement (string $name, int $department_id, int $job_id, string $phone, int $level, string $entry_at, string $nickname = '') {
        return self::getClass()->addStaffWithAutoIncrement([
            "name" => $name,
            "department_id" => $department_id,
            "job_id" => $job_id,
            "phone" => $phone,
            "level" => $level,
            "entry_at" => $entry_at,
            "nickname" => $nickname,
        ]);
    }

    /**
     * 使用钉钉回调通知更新伙伴信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStaffByDingTalkReq () {
        return self::getClass()->updateStaffByDingTalkReq();
    }

    /**
     * 完善添加钉钉用户异常数据（开启隐私保护的）
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeExceptionDingTalkCreateStaff () {
        return self::getClass()->completeExceptionDingTalkCreateStaff();
    }

    /**
     * 强制删除伙伴
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forceRemoveStaff (int $staffId) {
        return self::getClass()->forceRemoveStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 修改伙伴信息
     *
     * @param  int $job_id 岗位id [ require true ]
     * @param  int $id 伙伴 id [ require true ]
     * @param  string $name 名字 [ require true ]
     * @param  string $dingding_uid 钉钉uid [ require true ]
     * @param  string $phone 电话 [ require true ]
     * @param  string $nickname 花名 [ require true ]
     * @param  int $department_id 部门id [ require true ]
     * @param  int $level 职级 [ require true ]
     * @param  string $entry_at 入职时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStaffInfo (int $id, string $phone = '', string $name = '', string $nickname = '', string $dingding_uid = '', int $department_id = 0, int $level = NULL, int $job_id = 0, string $entry_at = '') {
        return self::getClass()->editStaffInfo([
            "id" => $id,
            "phone" => $phone,
            "name" => $name,
            "nickname" => $nickname,
            "dingding_uid" => $dingding_uid,
            "department_id" => $department_id,
            "level" => $level,
            "job_id" => $job_id,
            "entry_at" => $entry_at,
        ]);
    }

    /**
     * 伙伴离职
     *
     * @param  int $id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffResignation (int $id) {
        return self::getClass()->staffResignation([
            "id" => $id,
        ]);
    }

    /**
     * 伙伴复职
     *
     * @param  int $id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffUnResignation (int $id) {
        return self::getClass()->staffUnResignation([
            "id" => $id,
        ]);
    }

    /**
     * 根据管理店铺获取员工信息
     *
     * @param  int $store 门店ID [Original type uint] [ require true ]
     * @param  bool $withDeptStore 是否包含部门门店人员 [ require true ]
     * @param  int $count 获取记录条数 [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  bool $withDelete 是否包含离职员工 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffListByManageStore (int $store, int $page = 1, int $count = 10, bool $withDelete = false, bool $withDeptStore = false) {
        return self::getClass()->getStaffListByManageStore([
            "store" => $store,
            "page" => $page,
            "count" => $count,
            "withDelete" => $withDelete,
            "withDeptStore" => $withDeptStore,
        ]);
    }

    /**
     * 根据伙伴钉钉Id获取伙伴上级列表
     *
     * @param  string $dingTalkId 用户钉钉uid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryDeptManagerByStaff (string $dingTalkId) {
        return self::getClass()->queryDeptManagerByStaff([
            "dingTalkId" => $dingTalkId,
        ]);
    }

    /**
     * 获取伙伴所有上级部门
     *
     * @param  int $staffId 伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffAllDepParent (int $staffId) {
        return self::getClass()->getStaffAllDepParent([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 根据钉钉uid获取伙伴信息
     *
     * @param  string $dingId 钉钉UID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffDetailByDingId (string $dingId) {
        return self::getClass()->getStaffDetailByDingId([
            "dingId" => $dingId,
        ]);
    }

    /**
     * 创建兼岗
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  int $jobId 工作id [ require true ]
     * @param  int $operatorId 操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStaffPluralism (int $staffId, int $storeId, int $jobId, int $operatorId) {
        return self::getClass()->createStaffPluralism([
            "staffId" => $staffId,
            "storeId" => $storeId,
            "jobId" => $jobId,
            "operatorId" => $operatorId,
        ]);
    }

    /**
     * 操作兼岗请求
     *
     * @param  int $pluralismId 申请兼岗id [ require true ]
     * @param  string $type 操作类型 confirm: 同意 cancel： 撤销申请 stop：停止兼岗 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleStaffPluralism (int $pluralismId, string $type) {
        return self::getClass()->handleStaffPluralism([
            "pluralismId" => $pluralismId,
            "type" => $type,
        ]);
    }

    /**
     * 删除某伙伴所有兼岗信息
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffAllPluralism (int $staffId) {
        return self::getClass()->removeStaffAllPluralism([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 兼岗列表
     *
     * @param  array $storeIds 门店id [ require true ]
     * @param  array $pluralismStoreId 目标门店id [ require true ]
     * @param  int $jobId 职位id [ require true ]
     * @param  array $status 状态 [ require true ]
     * @param  bool $withDel 需要删除数据 [ require true ]
     * @param  array $staffIds 员工ids [ require true ]
     * @param  array $sortFields 排序列 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function staffPluralismList (array $storeIds = [], array $pluralismStoreId = [], array $status = [], int $jobId = 0, bool $withDel = false, array $staffIds = [], array $sortFields = [], int $page = 1, int $pageSize = 15) {
        return self::getClass()->staffPluralismList([
            "storeIds" => $storeIds,
            "pluralismStoreId" => $pluralismStoreId,
            "status" => $status,
            "jobId" => $jobId,
            "withDel" => $withDel,
            "staffIds" => $staffIds,
            "sortFields" => $sortFields,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 统计兼岗状态数量
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function countPluralismNum (array $storeIds) {
        return self::getClass()->countPluralismNum([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取兼岗详情
     *
     * @param  int $pluralismId 兼岗id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffPluralismDetail (int $pluralismId) {
        return self::getClass()->getStaffPluralismDetail([
            "pluralismId" => $pluralismId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}