<?php
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addDepartmentByParams(array $params)
 * @method editDepartmentByParams(array $params)
 * @method delDepartmentByParams(array $params)
 * @method addPositionByParams(array $params)
 * @method editPositionNameByParams(array $params)
 * @method delPositionByParams(array $params)
 * @method getDepartmentDetailByParams(array $params)
 * @method getPositionDetailByParams(array $params)
 * @method getAreaTranslateByParams(array $params)
 * @method getStoreByDeptIdByParams(array $params)
 * @method getDepartmentByParams(array $params)
 * @method getFamilyDepartmentByParams(array $params)
 * @method getPositionByParams(array $params)
 * @method searchByLevelByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增架构
     *
     * @param  int $id id [ require true ]
     * @param  int $parent 父department-create级id [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  string $name 架构名称 [ require true ]
     * @param  string $dingding_id 钉钉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addDepartment (int $id, int $parent, int $store_id, string $name, string $dingding_id) {
        return self::getClass()->addDepartment([
            "id" => $id,
            "parent" => $parent,
            "store_id" => $store_id,
            "name" => $name,
            "dingding_id" => $dingding_id,
        ]);
    }

    /**
     * 修改架构
     *
     * @param  int $id 架构id [ require true ]
     * @param  string $name 架构名称 [ require true ]
     * @param  int $parent 父级id [ require true ]
     * @param  string $dingding_id 钉钉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editDepartment (int $id, string $name = '', int $parent = NULL, string $dingding_id = '') {
        return self::getClass()->editDepartment([
            "id" => $id,
            "name" => $name,
            "parent" => $parent,
            "dingding_id" => $dingding_id,
        ]);
    }

    /**
     * 删除架构
     *
     * @param  int $id 架构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delDepartment (int $id) {
        return self::getClass()->delDepartment([
            "id" => $id,
        ]);
    }

    /**
     * 新增部门
     *
     * @param  int $id 部门id [ require true ]
     * @param  string $name 部门名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPosition (int $id, string $name) {
        return self::getClass()->addPosition([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 修改部门名称
     *
     * @param  int $id 部门id [ require true ]
     * @param  string $name 部门名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editPositionName (int $id, string $name = '') {
        return self::getClass()->editPositionName([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 删除部门
     *
     * @param  int $id 部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delPosition (int $id) {
        return self::getClass()->delPosition([
            "id" => $id,
        ]);
    }

    /**
     * 根据部门ID获取部门详情
     *
     * @param  array $deptIds 部门IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentDetail (array $deptIds) {
        return self::getClass()->getDepartmentDetail([
            "deptIds" => $deptIds,
        ]);
    }

    /**
     * 根据职位ID获取职位详情
     *
     * @param  array $positionIds 职位ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPositionDetail (array $positionIds) {
        return self::getClass()->getPositionDetail([
            "positionIds" => $positionIds,
        ]);
    }

    /**
     * 转换区域名称
     *
     * @param  array $deptIds 部门IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaTranslate (array $deptIds) {
        return self::getClass()->getAreaTranslate([
            "deptIds" => $deptIds,
        ]);
    }

    /**
     * 根据部门ID获取店铺ID
     *
     * @param  int $deptId 部门ID [ require true ]
     * @param  bool $withDel 是否需要已删除数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByDeptId (int $deptId, bool $withDel = false) {
        return self::getClass()->getStoreByDeptId([
            "deptId" => $deptId,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 获取部门列表
     *
     * @param  string $name 部门名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDepartment (string $name = '') {
        return self::getClass()->getDepartment([
            "name" => $name,
        ]);
    }

    /**
     * 获取部门所有关系部门
     *
     * @param  int $deptId 部门ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFamilyDepartment (int $deptId) {
        return self::getClass()->getFamilyDepartment([
            "deptId" => $deptId,
        ]);
    }

    /**
     * 获取岗位列表 (模糊查询匹配模式调用方自己处理)
     *
     * @param  string $name 部门名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPosition (string $name = '') {
        return self::getClass()->getPosition([
            "name" => $name,
        ]);
    }

    /**
     * 按父级id和level搜索信息
     *
     * @param  int $level level等级 [ require true ]
     * @param  int $parent_id 父级id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchByLevel (int $level = NULL, int $parent_id = NULL) {
        return self::getClass()->searchByLevel([
            "level" => $level,
            "parent_id" => $parent_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Staff', 'Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Staff', 'Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}