<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-07 17:30:25
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderV2
 * @method setOrderNameByParams(array $params) setOrderName
 * @method createByParams(array $params) 创建订单
 * @method addOrderAddressByParams(array $params) 根据订单id保存用户邮寄地址
 * @method detailByParams(array $params) 订单详情
 * @method orderLogisticsByParams(array $params) 订单物流信息
 * @method listByParams(array $params) 订单列表
 * @method closeByUserByParams(array $params) 用户手动关闭订单——未支付状态
 * @method closeByLimitTimeNotPaidByParams(array $params) 自动关闭已提交但是未支付的订单
 * @method judgeOrderWhetherSendSmsByParams(array $params) 检测订单12小时制作状态是否发送短信任务
 * @method receivedByUserByParams(array $params) 用户订单——手动收货
 * @method autoTimingReceiveOrderByParams(array $params) autoTimingReceiveOrder
 * @method autoReceiveOrderByParams(array $params) 对已全部发货订单，进行自动收货
 * @method orderStatusConfirmingByParams(array $params) 设置订单状态是支付确认中
 * @method orderListWithoutDetailByParams(array $params) 订单列表-不带完整的订单详情信息
 * @method orderListByParams(array $params) 订单列表-不分页
 * @method orderItemListByParams(array $params) 订单明细-不分页
 * @method manualChangeOrderStatusByParams(array $params) 修改订单状态
 * @method orderLogisticsByOrderIdByParams(array $params) 根据订单id获取物流单号
 * @method setPaidByParams(array $params) 设置订单完成支付
 */
class OrderV2 {
    private static string $serviceName = "RetailOrder";

    private static string $className = "OrderV2";

    /**
     * setOrderName
     * @return  mixed
    */
    public static function setOrderName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderName();
    }

    /**
     * 创建订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 根据订单id保存用户邮寄地址
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function addOrderAddress (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderAddress($_params);
    }

    /**
     * 订单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function detail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail($_params);
    }

    /**
     * 订单物流信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function orderLogistics (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogistics($_params);
    }

    /**
     * 订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 用户手动关闭订单——未支付状态
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function closeByUser (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByUser($_params);
    }

    /**
     * 自动关闭已提交但是未支付的订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function closeByLimitTimeNotPaid () {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByLimitTimeNotPaid();
    }

    /**
     * 检测订单12小时制作状态是否发送短信任务
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function judgeOrderWhetherSendSms () {
        return RpcClass::getClass(self::$serviceName, self::$className)->judgeOrderWhetherSendSms();
    }

    /**
     * 用户订单——手动收货
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function receivedByUser (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receivedByUser($_params);
    }

    /**
     * autoTimingReceiveOrder
     * @return  bool
    */
    public static function autoTimingReceiveOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoTimingReceiveOrder();
    }

    /**
     * 对已全部发货订单，进行自动收货
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function autoReceiveOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoReceiveOrder();
    }

    /**
     * 设置订单状态是支付确认中
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderStatusConfirming (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderStatusConfirming(["id" => $id]);
    }

    /**
     * 订单列表-不带完整的订单详情信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function orderListWithoutDetail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderListWithoutDetail($_params);
    }

    /**
     * 订单列表-不分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function orderList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderList($_params);
    }

    /**
     * 订单明细-不分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function orderItemList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderItemList($_params);
    }

    /**
     * 修改订单状态
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function manualChangeOrderStatus (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualChangeOrderStatus($_params);
    }

    /**
     * 根据订单id获取物流单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function orderLogisticsByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogisticsByOrderId(["orderId" => $orderId]);
    }

    /**
     * 设置订单完成支付
     * @return  bool
    */
    public static function setPaid (\Mainto\Bridge\Structs\RetailOrder\Cmd\OrderSetPaidCmd $orderSetPaidCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid($orderSetPaidCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}