<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-04 18:05:31
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Refund
 * @method listByParams(array $params) 退款列表
 * @method passByParams(array $params) 通过退款-非自动退款场景
 * @method rejectByParams(array $params) 拒绝退款
 * @method handleInvoiceProcessedByParams(array $params) 零售退款 - 查看详情 - 发票已处理
 * @method fastRefundRetailByIdByParams(array $params) 根据零售订单id，退款套餐中零售产品的钱，直接快速退款
 * @method refundAbnormalFinanceHandledByParams(array $params) 财务已处理-处理拉卡拉异常的退款单
 * @method setPayMaxRefundSuccessByParams(array $params) 设置拉卡拉退款异常存疑结果为拉卡拉已经退款
 * @method refundMoneyNoticeByParams(array $params) 退款成功通知 - 暂时无该业务
 * @method gatewayRefundCallbackByParams(array $params) 支付退款回调
 * @method setDouYinRefundStatusByParams(array $params) 设置抖音退款结果
 */
class Refund {
    private static string $serviceName = "RetailOrder";

    private static string $className = "Refund";

    /**
     * 退款列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 通过退款-非自动退款场景
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function pass (int $id, string $refundNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id, "refundNo" => $refundNo]);
    }

    /**
     * 拒绝退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function reject (int $id, string $reason = '', int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["id" => $id, "reason" => $reason, "operateId" => $operateId]);
    }

    /**
     * 零售退款 - 查看详情 - 发票已处理
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function handleInvoiceProcessed (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleInvoiceProcessed(["id" => $id]);
    }

    /**
     * 根据零售订单id，退款套餐中零售产品的钱，直接快速退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function fastRefundRetailById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fastRefundRetailById(["id" => $id]);
    }

    /**
     * 财务已处理-处理拉卡拉异常的退款单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function refundAbnormalFinanceHandled (int $id, string $refundNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundAbnormalFinanceHandled(["id" => $id, "refundNo" => $refundNo]);
    }

    /**
     * 设置拉卡拉退款异常存疑结果为拉卡拉已经退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setPayMaxRefundSuccess (int $refundId, string $passedAt, string $refundNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPayMaxRefundSuccess(["refundId" => $refundId, "passedAt" => $passedAt, "refundNo" => $refundNo]);
    }

    /**
     * 退款成功通知 - 暂时无该业务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function refundMoneyNotice (int $refundId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundMoneyNotice(["refundId" => $refundId]);
    }

    /**
     * 支付退款回调
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function gatewayRefundCallback (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->gatewayRefundCallback($_params);
    }

    /**
     * 设置抖音退款结果
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setDouYinRefundStatus (int $refundId, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setDouYinRefundStatus(["refundId" => $refundId, "status" => $status]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}