<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-04 18:05:31
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method createByParams(array $params) 创建零售订单
 * @method detailByParams(array $params) 订单详情
 * @method changePayTypeByParams(array $params) 修改订单支付方式
 * @method listByParams(array $params) 订单列表
 * @method setPaidByParams(array $params) 设置订单完成支付
 * @method autoCreateOrderRpcLogByParams(array $params) 同步订单打点数据
 * @method orderAfterPayByParams(array $params) 订单支付成功后续处理
 * @method closeByParams(array $params) 关闭订单——未支付的零售订单
 * @method closeWithPushByParams(array $params) 关闭订单——未完成支付的零售订单包含处理礼品卡预支付
 * @method authCloseNoPayOrderByParams(array $params) 每天定时关闭未支付的门店订单
 * @method getIdByNoByParams(array $params) 根据订单号获取订单ID
 * @method getPriceInfoByNoByParams(array $params) 根据订单号获取订单最大开票金额
 * @method getNoByIdByParams(array $params) 根据订单ID获取订单号
 * @method modifyOrderInputStaffIdByParams(array $params) 修改零售订单关联销售人员
 * @method serviceCompleteByParams(array $params) 设置服务完成
 * @method batchUpdateInvoiceIdByParams(array $params) 批量更新订单的发票ID
 * @method listInOrdersByParams(array $params) 根据订单号批量获取订单信息
 * @method getStaffRetailEffectByParams(array $params) 获取伙伴时间范围内累积零售产品销售
 * @method closeByHimoOrderIdByParams(array $params) 关闭订单
 * @method orderItemsFinishExpressByParams(array $params) 设置订单商品完成自提
 * @method orderIdBatchFinishExpressByParams(array $params) 根据订单id完成批量自提
 * @method orderItemsBatchFinishExpressByParams(array $params) 批量设置订单商品完成自提
 * @method orderItemsCancelExpressByParams(array $params) 取消订单商品完成自提状态
 * @method orderItemsBatchCancelExpressByParams(array $params) 批量取消订单商品完成自提状态
 * @method setOrderNameByParams(array $params) setOrderName
 * @method closeByPaidByParams(array $params) 关闭订单——已支付的零售订单
 * @method closePhotoSplitOrderByParams(array $params) 关闭订单——关闭source=photoSplitOrder的零售订单
 * @method changeOrderStatusByParams(array $params) 修改订单的状态-bms有改业务在使用
 * @method giftCardPayWithholdByParams(array $params) 进行礼品卡预扣（更新礼品卡金额useGiftCardMoney和预扣giftCardPrePay合并）
 * @method giftCardSubmitPrePayByParams(array $params) 对应已经使用礼品卡支付的订单，完成支付后，礼品卡暂扣金额进行实际扣除
 * @method cancelGiftCardPrePayByParams(array $params) 对应已经使用礼品卡预支付的订单，撤销预支付
 * @method getOrderGiftCardInfoByParams(array $params) 通过订单id查询用户是否使用了礼品卡暂扣，以及暂扣了多少
 * @method getOrderLogsByParams(array $params) 通过订单id查询操作日志
 * @method getOrderByIdByParams(array $params) 通过订单id查询Order
 * @method getOrderWithItemByIdByParams(array $params) 通过订单id查询Order和子订单信息
 * @method getRefundWithOrderByOrderNoByParams(array $params) 根据零售定单号获取未拒绝的退款金额
 * @method refundForMemberByParams(array $params) 退单关单——给0元单使用
 * @method modifyOrderStoreHimoOrderByParams(array $params) 修改订单归属门店和拍摄订单
 * @method modifyOrderStaffIdByOrderNoByParams(array $params) 根据订单编号修改售出伙伴id
 * @method getOrderItemsByOrderItemIdsByParams(array $params) 根据orderItemIds获取orderItems
 * @method getGiftCardPaymentNoByOrderIdByParams(array $params) 根据零售订单id获取礼品卡支付凭证
 * @method sendPerformanceNoticeByParams(array $params) 所有订单明细提货完成后，发送业绩通知
 */
class Order {
    private static string $serviceName = "RetailOrder";

    private static string $className = "Order";

    /**
     * 创建零售订单
     * @return  array
    */
    public static function create (\Mainto\Bridge\Structs\RetailOrder\Cmd\CreateOrderCmd $createOrderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createOrderCmd);
    }

    /**
     * 订单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function detail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail($_params);
    }

    /**
     * 修改订单支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function changePayType (int $id, string $payType, string $paymentNo = '', int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payType" => $payType, "paymentNo" => $paymentNo, "operateId" => $operateId]);
    }

    /**
     * 订单列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 设置订单完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function setPaid (int $id, float $money, string $payType, int $inputStaffId = 0, string $paymentNo = '', string $certificate = '', string $paymentTime = '', int $operateId = 0, int $himoOrderId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "money" => $money, "payType" => $payType, "inputStaffId" => $inputStaffId, "paymentNo" => $paymentNo, "certificate" => $certificate, "paymentTime" => $paymentTime, "operateId" => $operateId, "himoOrderId" => $himoOrderId]);
    }

    /**
     * 同步订单打点数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function autoCreateOrderRpcLog () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCreateOrderRpcLog();
    }

    /**
     * 订单支付成功后续处理
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderAfterPay (array $order) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderAfterPay(["order" => $order]);
    }

    /**
     * 关闭订单——未支付的零售订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $id, string $reason, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, "reason" => $reason, "operateId" => $operateId]);
    }

    /**
     * 关闭订单——未完成支付的零售订单包含处理礼品卡预支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closeWithPush (int $id, string $reason, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeWithPush(["id" => $id, "reason" => $reason, "operateId" => $operateId]);
    }

    /**
     * 每天定时关闭未支付的门店订单
     * @return  bool
    */
    public static function authCloseNoPayOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->authCloseNoPayOrder();
    }

    /**
     * 根据订单号获取订单ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getIdByNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNo(["orderNo" => $orderNo]);
    }

    /**
     * 根据订单号获取订单最大开票金额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPriceInfoByNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPriceInfoByNo(["orderNo" => $orderNo]);
    }

    /**
     * 根据订单ID获取订单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getNoById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNoById(["id" => $id]);
    }

    /**
     * 修改零售订单关联销售人员
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function modifyOrderInputStaffId (int $id, int $inputStaffId = 0, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyOrderInputStaffId(["id" => $id, "inputStaffId" => $inputStaffId, "operateId" => $operateId]);
    }

    /**
     * 设置服务完成
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function serviceComplete (int $id, bool $isUserComplete = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceComplete(["id" => $id, "isUserComplete" => $isUserComplete]);
    }

    /**
     * 批量更新订单的发票ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchUpdateInvoiceId (int $invoiceId, array $orderNos, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateInvoiceId(["invoiceId" => $invoiceId, "orderNos" => $orderNos, "operateId" => $operateId]);
    }

    /**
     * 根据订单号批量获取订单信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function listInOrders (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listInOrders($_params);
    }

    /**
     * 获取伙伴时间范围内累积零售产品销售
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffRetailEffect (int $staffId, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRetailEffect(["staffId" => $staffId, "startTime" => $startTime, "endTime" => $endTime]);
    }

    /**
     * 关闭订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeByHimoOrderId (int $himoOrderId, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByHimoOrderId(["himoOrderId" => $himoOrderId, "reason" => $reason]);
    }

    /**
     * 设置订单商品完成自提
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderItemsFinishExpress (int $itemId, int $storeId, int $deliveryId = 100001) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderItemsFinishExpress(["itemId" => $itemId, "storeId" => $storeId, "deliveryId" => $deliveryId]);
    }

    /**
     * 根据订单id完成批量自提
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderIdBatchFinishExpress (int $orderId, int $storeId, int $deliveryId = 100001) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderIdBatchFinishExpress(["orderId" => $orderId, "storeId" => $storeId, "deliveryId" => $deliveryId]);
    }

    /**
     * 批量设置订单商品完成自提
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderItemsBatchFinishExpress (array $itemIds, int $storeId, int $deliveryId = 100001) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderItemsBatchFinishExpress(["itemIds" => $itemIds, "storeId" => $storeId, "deliveryId" => $deliveryId]);
    }

    /**
     * 取消订单商品完成自提状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderItemsCancelExpress (int $itemId, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderItemsCancelExpress(["itemId" => $itemId, "storeId" => $storeId]);
    }

    /**
     * 批量取消订单商品完成自提状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function orderItemsBatchCancelExpress (array $itemIds, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderItemsBatchCancelExpress(["itemIds" => $itemIds, "storeId" => $storeId]);
    }

    /**
     * setOrderName
     * @return  mixed
    */
    public static function setOrderName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderName();
    }

    /**
     * 关闭订单——已支付的零售订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closeByPaid (int $id, string $reason, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByPaid(["id" => $id, "reason" => $reason, "operateId" => $operateId]);
    }

    /**
     * 关闭订单——关闭source=photoSplitOrder的零售订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closePhotoSplitOrder (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closePhotoSplitOrder(["id" => $id, "reason" => $reason]);
    }

    /**
     * 修改订单的状态-bms有改业务在使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeOrderStatus (int $id, string $status, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeOrderStatus(["id" => $id, "status" => $status, "operateId" => $operateId]);
    }

    /**
     * 进行礼品卡预扣（更新礼品卡金额useGiftCardMoney和预扣giftCardPrePay合并）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function giftCardPayWithhold (int $id, float $giftCardPayMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardPayWithhold(["id" => $id, "giftCardPayMoney" => $giftCardPayMoney]);
    }

    /**
     * 对应已经使用礼品卡支付的订单，完成支付后，礼品卡暂扣金额进行实际扣除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function giftCardSubmitPrePay (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardSubmitPrePay(["id" => $id]);
    }

    /**
     * 对应已经使用礼品卡预支付的订单，撤销预支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelGiftCardPrePay (int $id, string $giftCardPaymentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelGiftCardPrePay(["id" => $id, "giftCardPaymentNo" => $giftCardPaymentNo]);
    }

    /**
     * 通过订单id查询用户是否使用了礼品卡暂扣，以及暂扣了多少
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderGiftCardInfo (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderGiftCardInfo(["orderId" => $orderId]);
    }

    /**
     * 通过订单id查询操作日志
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderLogs (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderLogs(["orderId" => $orderId]);
    }

    /**
     * 通过订单id查询Order
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderById(["id" => $id]);
    }

    /**
     * 通过订单id查询Order和子订单信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderWithItemById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderWithItemById(["id" => $id]);
    }

    /**
     * 根据零售定单号获取未拒绝的退款金额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getRefundWithOrderByOrderNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRefundWithOrderByOrderNo(["orderNo" => $orderNo]);
    }

    /**
     * 退单关单——给0元单使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function refundForMember (int $id, string $reason, int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundForMember(["id" => $id, "reason" => $reason, "operateId" => $operateId]);
    }

    /**
     * 修改订单归属门店和拍摄订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function modifyOrderStoreHimoOrder (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyOrderStoreHimoOrder($_params);
    }

    /**
     * 根据订单编号修改售出伙伴id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function modifyOrderStaffIdByOrderNo (string $orderNo, int $inputStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyOrderStaffIdByOrderNo(["orderNo" => $orderNo, "inputStaffId" => $inputStaffId]);
    }

    /**
     * 根据orderItemIds获取orderItems
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderItemsByOrderItemIds (array $orderItemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderItemsByOrderItemIds(["orderItemIds" => $orderItemIds]);
    }

    /**
     * 根据零售订单id获取礼品卡支付凭证
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getGiftCardPaymentNoByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardPaymentNoByOrderId(["orderId" => $orderId]);
    }

    /**
     * 所有订单明细提货完成后，发送业绩通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendPerformanceNotice (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPerformanceNotice(["order_id" => $order_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}