<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-02 18:03:17
 */
namespace Mainto\Bridge\Structs\RetailOrder\Cmd;

class OrderSetPaidCmd {
    /**
     * @var  int
     * 订单ID
     * validation: required_without:himoOrderId
     */
    public int $orderId;
    /**
     * @var  null|int
     * 海马体订单id
     * validation: required_without:id
     */
    public ?int $himoOrderId;
    /**
     * @var  null|int
     * 售出伙伴ID
     * validation: 
     */
    public ?int $inputStaffId = null;
    /**
     * @var  int
     * 操作伙伴ID(后台操作时必须添加)
     * validation: 
     */
    public int $operateId;
    /**
     * @var  null|string
     * 支付时间
     * validation: date_format:Y-m-d H:i:s
     */
    public ?string $paymentTime = null;
    /**
     * @var  \Mainto\Bridge\Structs\RetailOrder\Cmd\OrderPaidTurnoversCmd[]
     * 支付记录
     * validation: 
     */
    public array $payRecords;

    public function __construct (int $orderId = 0, ?int $himoOrderId = 0, int $operateId = 0, array $payRecords = []) {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($himoOrderId)) {
            $this->himoOrderId = $himoOrderId;
        }
        if (!is_null($operateId)) {
            $this->operateId = $operateId;
        }
        if (!is_null($payRecords)) {
            $this->payRecords = $payRecords;
        }
    }

    public static function create(int $orderId = 0, ?int $himoOrderId = 0, int $operateId = 0, array $payRecords = []): self {
        return new self($orderId, $himoOrderId, $operateId, $payRecords);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setHimoOrderId(?int $himoOrderId): self {
        $this->himoOrderId = $himoOrderId;

        return $this;
    }

    public function setInputStaffId(?int $inputStaffId): self {
        $this->inputStaffId = $inputStaffId;

        return $this;
    }

    public function setOperateId(int $operateId): self {
        $this->operateId = $operateId;

        return $this;
    }

    public function setPaymentTime(?string $paymentTime): self {
        $this->paymentTime = $paymentTime;

        return $this;
    }

    public function setPayRecords(array $payRecords): self {
        $this->payRecords = $payRecords;

        return $this;
    }
}