<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-02 18:35:24
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductOrder
 */
class ProductOrder {
    private static string $serviceName = "RetailOrder";

    private static string $className = "ProductOrder";

    /**
     * setProductOrderName
     * @return  mixed
    */
    public static function setProductOrderName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductOrderName();
    }
    /**
     * setProductOrderTaskName
     * @return  mixed
    */
    public static function setProductOrderTaskName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductOrderTaskName();
    }
    /**
     * 创建生产单
     * @return  array
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }
    /**
     * 生产订单详情
     * @return  array
    */
    public static function detail (int $productOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["productOrderId" => $productOrderId]);
    }
    /**
     * 生产订单绑定用户选中的照片
     * @return  bool
    */
    public static function productOrderBindImage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOrderBindImage($_params);
    }
    /**
     * 获取生产订单绑定的照片
     * @return  array
    */
    public static function productOrderImages (int $productOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOrderImages(["productOrderId" => $productOrderId]);
    }
    /**
     * 生产订单状态变动回调
     * @return  bool
    */
    public static function callBackProductStatusChange (array $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callBackProductStatusChange(["content" => $content]);
    }
    /**
     * 获取跳转编辑器的参数信息
     * @return  array
    */
    public static function getEditorJumpParams (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEditorJumpParams($_params);
    }
    /**
     * 通过skuid获取第三方模版数据
     * @return  array
    */
    public static function getOutTemplateBySkuId (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOutTemplateBySkuId(["productSkuId" => $productSkuId]);
    }
    /**
     * 设置用户著作单作品缩略图
     * @return  mixed
    */
    public static function setUserCompositionThumbnail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserCompositionThumbnail($_params);
    }
    /**
     * 生产订单列表-不分页
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }
    /**
     * 上传用户作品图
     * @return  bool
    */
    public static function updateUserImageInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserImageInfo($_params);
    }
    /**
     * 上传用户作品图-书册类
     * @return  bool
    */
    public static function updateUserOpusInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserOpusInfo($_params);
    }
    /**
     * 上传用户制作原图
     * @return  array
    */
    public static function updateOriginalImage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOriginalImage($_params);
    }
    /**
     * 生产订单列表-分页
     * @return  array
    */
    public static function listWithPaginator (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginator($_params);
    }
    /**
     * 根据生产单ids,增加导出次数
     * @return  bool
    */
    public static function incrExportByProductOrderIds (array $productOrderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->incrExportByProductOrderIds(["productOrderIds" => $productOrderIds]);
    }
    /**
     * 根据生产单子单id,查看详情
     * @return  array
    */
    public static function detailByProductOrderItemId (int $productOrderItemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByProductOrderItemId(["productOrderItemId" => $productOrderItemId]);
    }
    /**
     * 根据零售子单ids获取生产单关联items
     * @return  array
    */
    public static function getItemsByOrderItemIds (array $orderItemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemsByOrderItemIds(["orderItemIds" => $orderItemIds]);
    }
    /**
     * 单个生产订单批量绑定快递单号
     * @return  bool
    */
    public static function createLogistics (string $productOrderNo, array $logisticsNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createLogistics(["productOrderNo" => $productOrderNo, "logisticsNos" => $logisticsNos]);
    }
    /**
     * 用户作品回调更新数据
     * @return  bool
    */
    public static function callbackProductOrderItem (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackProductOrderItem($_params);
    }
    /**
     * 修改生产单备注
     * @return  bool
    */
    public static function editProductOrderNote (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editProductOrderNote($_params);
    }
    /**
     * 自动同步到生产单数据
     * @return  bool
    */
    public static function autoCreateProductOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCreateProductOrder();
    }
    /**
     * 草稿直接提交生产
     * @return  bool
    */
    public static function submitCreateProductOrder (?\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\UpdateDraftCmd $updateDraftCmd = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitCreateProductOrder($updateDraftCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}