<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-27 20:45:10
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AfterSale
 */
class AfterSale {
    private static string $serviceName = "RetailOrder";

    private static string $className = "AfterSale";

    /**
     * 创建售后单
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }
    /**
     * 检查最大可以退款金额是否符合要求
     * @return  bool
    */
    public static function checkCanRefundMaxMoney (int $orderId, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkCanRefundMaxMoney(["orderId" => $orderId, "money" => $money]);
    }
    /**
     * 检查退货数量是否符合要求
     * @return  bool
    */
    public static function checkReturnGoodsNum (int $orderId, array $refundItemDetail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkReturnGoodsNum(["orderId" => $orderId, "refundItemDetail" => $refundItemDetail]);
    }
    /**
     * 根据零售订单id查询售后单
     * @return  mixed
    */
    public static function getByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByOrderId(["orderId" => $orderId]);
    }
    /**
     * 根据售后单id查询售后单详情
     * @return  array
    */
    public static function getDetailById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetailById(["id" => $id]);
    }
    /**
     * 获取售后列表
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }
    /**
     * 获取售后，退款，退货信息
     * @return  array
    */
    public static function listWithRefundAndReturnGoods (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithRefundAndReturnGoods($_params);
    }
    /**
     * 根据售后单id关闭售后单
     * @return  bool
    */
    public static function close (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id]);
    }
    /**
     * 重新提交售后单
     * @return  bool
    */
    public static function resubmit (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resubmit($_params);
    }
    /**
     * 根据零售订单id查询退货信息
     * @return  array
    */
    public static function getReturnGoodsByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReturnGoodsByOrderId(["orderId" => $orderId]);
    }
    /**
     * 根据零售订单id查询退货信息和退货itmes信息
     * @return  mixed
    */
    public static function getAfterSaleItemsByAfterSaleIds (array $afterSaleIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleItemsByAfterSaleIds(["afterSaleIds" => $afterSaleIds]);
    }
    /**
     * 根据零售订单id查询退款信息
     * @return  array
    */
    public static function getRefundByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRefundByOrderId(["orderId" => $orderId]);
    }
    /**
     * 根据零售订单ids查询退款信息
     * @return  array
    */
    public static function getRefundByOrderIds (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRefundByOrderIds(["orderIds" => $orderIds]);
    }
    /**
     * 根据售后单id，处理下层的退款单
     * @return  bool
    */
    public static function handleAfterSaleRefund (array $afterSale) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleAfterSaleRefund(["afterSale" => $afterSale]);
    }
    /**
     * 根据订单id获取售后单AfterSaleItem信息
     * @return  array
    */
    public static function getAfterSaleItemsByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAfterSaleItemsByOrderId(["orderId" => $orderId]);
    }
    /**
     * 根据订单id获取售后单AfterSaleItem信息
     * @return  bool
    */
    public static function cancelRefundByAfterSaleId (int $afterSaleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelRefundByAfterSaleId(["afterSaleId" => $afterSaleId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}