<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-31 11:49:18
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderItemLogistics
 */
class OrderItemLogistics {
    private static string $serviceName = "RetailOrder";

    private static string $className = "OrderItemLogistics";

    /**
     * 创建物流信息记录
     * @return  array
    */
    public static function create (int $orderId, int $orderItemId, int $productOrderId, int $productOrderItemId, string $logisticsNo, string $source, array $logisticsInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "orderItemId" => $orderItemId, "productOrderId" => $productOrderId, "productOrderItemId" => $productOrderItemId, "logisticsNo" => $logisticsNo, "source" => $source, "logisticsInfo" => $logisticsInfo]);
    }
    /**
     * 物流记录列表-不分页
     * @return  array
    */
    public static function list (int $id, array $ids, int $orderId, array $orderIds, int $orderItemId, array $orderItemIds, int $productOrderId, array $productOrderIds, int $productOrderItemId, array $productOrderItemIds, string $logisticsNo, array $logisticsNos, string $source, array $sources) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["id" => $id, "ids" => $ids, "orderId" => $orderId, "orderIds" => $orderIds, "orderItemId" => $orderItemId, "orderItemIds" => $orderItemIds, "productOrderId" => $productOrderId, "productOrderIds" => $productOrderIds, "productOrderItemId" => $productOrderItemId, "productOrderItemIds" => $productOrderItemIds, "logisticsNo" => $logisticsNo, "logisticsNos" => $logisticsNos, "source" => $source, "sources" => $sources]);
    }
    /**
     * 物流记录列表-分页
     * @return  array
    */
    public static function listWithPaginator (int $id, array $ids, int $orderId, array $orderIds, int $orderItemId, array $orderItemIds, int $productOrderId, array $productOrderIds, int $productOrderItemId, array $productOrderItemIds, string $logisticsNo, array $logisticsNos, string $source, array $sources, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginator(["id" => $id, "ids" => $ids, "orderId" => $orderId, "orderIds" => $orderIds, "orderItemId" => $orderItemId, "orderItemIds" => $orderItemIds, "productOrderId" => $productOrderId, "productOrderIds" => $productOrderIds, "productOrderItemId" => $productOrderItemId, "productOrderItemIds" => $productOrderItemIds, "logisticsNo" => $logisticsNo, "logisticsNos" => $logisticsNos, "source" => $source, "sources" => $sources, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}