<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-27 17:36:29
 */
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderStatusEnum {
    /**
     * 已提交：创建了订单，但是还没有完全支付完成
     */
    const SUBMITTED = "submitted";
    /**
     * 支付确认中：业务没有使用
     */
    const CONFIRMING = "confirming";
    /**
     * 已支付：订单已经完全完成支付,订单已经提货数量n（n=0）
     */
    const PAID = "paid";
    /**
     * 运送中：订单已经提货数量n（1&lt;=n&lt;N）
     */
    const TRANSPORTING = "transporting";
    /**
     * 已完成:订单已经提货数量n（n=N）
     */
    const FINISHED = "finished";
    /**
     * 已关闭 - 正常关闭（一般是提交订单但是没有支付的场景下关闭的）
     */
    const CLOSED = "closed";
    /**
     * 售后关闭 - 通过售后单，将所有的商品进行售后。订单商品全部都进行了售后
     */
    const AFTER_SALE_CLOSED = "after_sale_closed";
    /**
     * 财务关闭 - 财务将现金支付的订单进行手动关闭
     */
    const FINANCE_CLOSED = "finance_closed";
    /**
     * 所有的订单状态
     */
    const ALL_ORDER_STATUS = ["submitted","confirming","paid","transporting","finished","closed","after_sale_closed","finance_closed"];
    /**
     * 修改订单状态枚举
     */
    const CHANGE_ORDER_STATUS = ['paid' => ["paid"],'finished' => ["finished"],'submitted' => ["submitted"]];
}