<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-20 14:19:18
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Coupon
 */
class Coupon {
    private static string $serviceName = "RetailOrder";

    private static string $className = "Coupon";

    /**
     * 获取用户中心优惠券列表
     */
    public static function getUserCoupons (int $userId, array $status, string $applyIn = 'retail'): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserCoupons(["userId" => $userId, "status" => $status, "applyIn" => $applyIn, ]);
    }
    /**
     * 删除优惠券配置信息
     */
    public static function deleteSettingCoupon (array $ids): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSettingCoupon(["ids" => $ids, ]);
    }
    /**
     * 获取优惠券配置列表
     */
    public static function getSettingCouponList (string $type, string $applyIn = 'retail', array $ids, string $createdAtEnd, string $createdAtStart, int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSettingCouponList(["type" => $type, "applyIn" => $applyIn, "ids" => $ids, "createdAtEnd" => $createdAtEnd, "createdAtStart" => $createdAtStart, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 创建绑定单个用户优惠卷
     */
    public static function bindUserCoupons (int $userId, string $applyScene): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserCoupons(["userId" => $userId, "applyScene" => $applyScene, ]);
    }
    /**
     * 根据应用场景获取零售优惠券展示信息
     */
    public static function getCouponByScene (int $userId, string $applyScene): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponByScene(["userId" => $userId, "applyScene" => $applyScene, ]);
    }
    /**
     * 创建优惠券
     */
    public static function bulkGenerateCoupons (int $count, int $recordId, string $title, int $userId, string $applyScene, string $status, int $templateId, string $buyChannel, float $discount, string $stopUsage, string $startUsage, string $limit, string $timeType, int $timeLong, array $extend, int $createdBy, array $phones): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bulkGenerateCoupons(["count" => $count, "recordId" => $recordId, "title" => $title, "userId" => $userId, "applyScene" => $applyScene, "status" => $status, "templateId" => $templateId, "buyChannel" => $buyChannel, "discount" => $discount, "stopUsage" => $stopUsage, "startUsage" => $startUsage, "limit" => $limit, "timeType" => $timeType, "timeLong" => $timeLong, "extend" => $extend, "createdBy" => $createdBy, "phones" => $phones, ]);
    }
    /**
     * 检测商品信息和优惠券信息计算优惠信息
     */
    public static function getSkuEffectiveCoupons (int $userId, array $products, array $ids): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuEffectiveCoupons(["userId" => $userId, "products" => $products, "ids" => $ids, ]);
    }
    /**
     * 支付完成后发放优惠券
     */
    public static function autoGrantPayCompletedCoupon (array $order): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoGrantPayCompletedCoupon(["order" => $order, ]);
    }
    /**
     * 批量发放关联优惠券
     */
    public static function grantCoupon (int $orderId, int $userId, string $scene, array $items): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantCoupon(["orderId" => $orderId, "userId" => $userId, "scene" => $scene, "items" => $items, ]);
    }
    /**
     * abolishCoupons
     */
    public static function abolishCoupons (string $scene, int $orderId, array $orderItemIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCoupons(["scene" => $scene, "orderId" => $orderId, "orderItemIds" => $orderItemIds, ]);
    }
    /**
     * couponGrantRecordList
     */
    public static function couponGrantRecordList (string $scene, int $orderId, array $orderItemIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->couponGrantRecordList(["scene" => $scene, "orderId" => $orderId, "orderItemIds" => $orderItemIds, ]);
    }
    /**
     * 批量自动绑定优惠券
     */
    public static function autoPhoneBindCoupon (array $phones, int $templateId, int $createBy, int $settingId, string $stopUsage, string $startUsage, string $title, string $channel, float $discount = 0): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoPhoneBindCoupon(["phones" => $phones, "templateId" => $templateId, "createBy" => $createBy, "settingId" => $settingId, "stopUsage" => $stopUsage, "startUsage" => $startUsage, "title" => $title, "channel" => $channel, "discount" => $discount, ]);
    }
    /**
     * 批量绑定手机号指定优惠券
     */
    public static function autoBatchGrantCodes (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoBatchGrantCodes();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}