<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 19:41:55
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderV2
 */
class OrderV2 {
    private static string $serviceName = "RetailOrder";

    private static string $className = "OrderV2";

    /**
     * setOrderName
     */
    public static function setOrderName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderName();
    }
    /**
     * 创建订单
     */
    public static function create (int $userId, string $userName, string $userPhone, string $userSex, string $userBirthday, float $money, float $originalMoney, float $realMoney, array $detail, int $inputStaffId, string $note, int $storeId, string $from = 'mobile', string $source, string $isUrgent, array $couponIds, array $expressInfo, array $shopCartIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["userId" => $userId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userBirthday" => $userBirthday, "money" => $money, "originalMoney" => $originalMoney, "realMoney" => $realMoney, "detail" => $detail, "inputStaffId" => $inputStaffId, "note" => $note, "storeId" => $storeId, "from" => $from, "source" => $source, "isUrgent" => $isUrgent, "couponIds" => $couponIds, "expressInfo" => $expressInfo, "shopCartIds" => $shopCartIds, ]);
    }
    /**
     * 根据订单id保存用户邮寄地址
     */
    public static function addOrderAddress (int $orderId, array $expressInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderAddress(["orderId" => $orderId, "expressInfo" => $expressInfo, ]);
    }
    /**
     * 订单详情
     */
    public static function detail (int $id, string $orderNo, string $source): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "orderNo" => $orderNo, "source" => $source, ]);
    }
    /**
     * 订单物流信息
     */
    public static function orderLogistics (int $orderId, array $itemIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogistics(["orderId" => $orderId, "itemIds" => $itemIds, ]);
    }
    /**
     * 订单列表
     */
    public static function list (int $himoOrderId, array $himoOrderIds, string $userPhone, string $createTimeStart, string $createTimeEnd, string $paidTimeStart, string $paidTimeEnd, string $userName, int $userId, string $orderNo, string $productOrderNo, int $storeId, string $status, int $inputStaffId, int $invoiceId, array $statusList, string $payType, string $from, array $fromList, string $source, array $sources, int $page, int $pageSize, string $expressStatus): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["himoOrderId" => $himoOrderId, "himoOrderIds" => $himoOrderIds, "userPhone" => $userPhone, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "paidTimeStart" => $paidTimeStart, "paidTimeEnd" => $paidTimeEnd, "userName" => $userName, "userId" => $userId, "orderNo" => $orderNo, "productOrderNo" => $productOrderNo, "storeId" => $storeId, "status" => $status, "inputStaffId" => $inputStaffId, "invoiceId" => $invoiceId, "statusList" => $statusList, "payType" => $payType, "from" => $from, "fromList" => $fromList, "source" => $source, "sources" => $sources, "page" => $page, "pageSize" => $pageSize, "expressStatus" => $expressStatus, ]);
    }
    /**
     * 用户手动关闭订单——未支付状态
     */
    public static function closeByUser (int $userId, int $id, string $reason): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByUser(["userId" => $userId, "id" => $id, "reason" => $reason, ]);
    }
    /**
     * 自动关闭已提交但是未支付的订单
     */
    public static function closeByLimitTimeNotPaid (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByLimitTimeNotPaid();
    }
    /**
     * 检测订单12小时制作状态是否发送短信任务
     */
    public static function judgeOrderWhetherSendSms (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->judgeOrderWhetherSendSms();
    }
    /**
     * 用户订单——手动收货
     */
    public static function receivedByUser (int $userId, int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->receivedByUser(["userId" => $userId, "id" => $id, ]);
    }
    /**
     * autoTimingReceiveOrder
     */
    public static function autoTimingReceiveOrder (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoTimingReceiveOrder();
    }
    /**
     * 对已全部发货订单，进行自动收货
     */
    public static function autoReceiveOrder (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoReceiveOrder();
    }
    /**
     * 设置订单状态是支付确认中
     */
    public static function orderStatusConfirming (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderStatusConfirming(["id" => $id, ]);
    }
    /**
     * 订单列表-不带完整的订单详情信息
     */
    public static function orderListWithoutDetail (array $ids, array $orderNos): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderListWithoutDetail(["ids" => $ids, "orderNos" => $orderNos, ]);
    }
    /**
     * 订单列表-不分页
     */
    public static function orderList (array $ids, string $orderNo, string $createTimeStart, string $createTimeEnd, string $userPhone, string $status, int $storeId, string $from, string $source, int $inputStaffId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderList(["ids" => $ids, "orderNo" => $orderNo, "createTimeStart" => $createTimeStart, "createTimeEnd" => $createTimeEnd, "userPhone" => $userPhone, "status" => $status, "storeId" => $storeId, "from" => $from, "source" => $source, "inputStaffId" => $inputStaffId, ]);
    }
    /**
     * 订单明细-不分页
     */
    public static function orderItemList (array $orderItemIds, array $orderIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderItemList(["orderItemIds" => $orderItemIds, "orderIds" => $orderIds, ]);
    }
    /**
     * 修改订单状态
     */
    public static function manualChangeOrderStatus (string $status, int $orderId, int $orderItemId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualChangeOrderStatus(["status" => $status, "orderId" => $orderId, "orderItemId" => $orderItemId, ]);
    }
    /**
     * 根据订单id获取物流单号
     */
    public static function orderLogisticsByOrderId (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogisticsByOrderId(["orderId" => $orderId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}