<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 19:41:55
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Distribution
 */
class Distribution {
    private static string $serviceName = "RetailOrder";

    private static string $className = "Distribution";

    /**
     * 用户id通过分销功能绑定员工id
     */
    public static function bindStaffId (int $userId, int $staffId, int $storeId = 0): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindStaffId(["userId" => $userId, "staffId" => $staffId, "storeId" => $storeId, ]);
    }
    /**
     * 根据用户id获取绑定员工id
     */
    public static function getStaffIdByUserId (int $userId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdByUserId(["userId" => $userId, ]);
    }
    /**
     * 根据员工id获取绑定用户id列表
     */
    public static function getUserIdsByStaffId (int $staffId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserIdsByStaffId(["staffId" => $staffId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}