<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:15:11
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Verify
 */
class Verify {
    private static string $serviceName = "RetailOrder";

    private static string $className = "Verify";

    /**
     * 通过提货码查询核销信息
     */
    public static function getByCode (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByCode(["code" => $code, ]);
    }
    /**
     * 通过订单号查询核销信息
     */
    public static function getByOrderNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByOrderNo(["orderNo" => $orderNo, ]);
    }
    /**
     * 通过订单号查询核销信息，可以查询已经删除的信息
     */
    public static function getVerifyWithDeleteStatusByOrderNo (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getVerifyWithDeleteStatusByOrderNo(["orderNo" => $orderNo, ]);
    }
    /**
     * 确认核销，删除提货码
     */
    public static function remove (string $code): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["code" => $code, ]);
    }
    /**
     * removeVerifyCode
     */
    public static function removeVerifyCode (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeVerifyCode();
    }
    /**
     * 确认核销，删除提货码
     */
    public static function resetVerify (string $code): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetVerify(["code" => $code, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}