<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 17:15:11
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductOrder
 */
class ProductOrder {
    private static string $serviceName = "RetailOrder";

    private static string $className = "ProductOrder";

    /**
     * setProductOrderName
     */
    public static function setProductOrderName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductOrderName();
    }
    /**
     * setProductOrderTaskName
     */
    public static function setProductOrderTaskName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductOrderTaskName();
    }
    /**
     * 创建生产单
     */
    public static function create (int $orderId, int $orderItemId, int $num = 1): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["orderId" => $orderId, "orderItemId" => $orderItemId, "num" => $num, ]);
    }
    /**
     * 生产订单详情
     */
    public static function detail (int $productOrderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["productOrderId" => $productOrderId, ]);
    }
    /**
     * 生产订单绑定用户选中的照片
     */
    public static function productOrderBindImage (int $productOrderId, array $imgIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOrderBindImage(["productOrderId" => $productOrderId, "imgIds" => $imgIds, ]);
    }
    /**
     * 获取生产订单绑定的照片
     */
    public static function productOrderImages (int $productOrderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOrderImages(["productOrderId" => $productOrderId, ]);
    }
    /**
     * 生产订单状态变动回调
     */
    public static function callBackProductStatusChange (array $content): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->callBackProductStatusChange(["content" => $content, ]);
    }
    /**
     * 获取跳转编辑器的参数信息
     */
    public static function getEditorJumpParams (int $userId, string $outOrderNo): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEditorJumpParams(["userId" => $userId, "outOrderNo" => $outOrderNo, ]);
    }
    /**
     * 通过skuid获取第三方模版数据
     */
    public static function getOutTemplateBySkuId (int $productSkuId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOutTemplateBySkuId(["productSkuId" => $productSkuId, ]);
    }
    /**
     * 设置用户著作单作品缩略图
     */
    public static function setUserCompositionThumbnail (int $productOrderId, string $thumbnailUrl, string $description, string $name, string $originImageUrl, int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setUserCompositionThumbnail(["productOrderId" => $productOrderId, "thumbnailUrl" => $thumbnailUrl, "description" => $description, "name" => $name, "originImageUrl" => $originImageUrl, "productId" => $productId, ]);
    }
    /**
     * 生产订单列表-不分页
     */
    public static function list (int $id, array $ids, string $productOrderNo, array $productOrderNos, string $status, array $statusList, int $orderId, array $orderIds, int $orderItemId, array $orderItemIds, string $supplierCode, array $supplierCodes, int $export): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["id" => $id, "ids" => $ids, "productOrderNo" => $productOrderNo, "productOrderNos" => $productOrderNos, "status" => $status, "statusList" => $statusList, "orderId" => $orderId, "orderIds" => $orderIds, "orderItemId" => $orderItemId, "orderItemIds" => $orderItemIds, "supplierCode" => $supplierCode, "supplierCodes" => $supplierCodes, "export" => $export, ]);
    }
    /**
     * 上传用户作品图
     */
    public static function updateUserImageInfo (int $productOrderItemId, array $userImage, string $status): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserImageInfo(["productOrderItemId" => $productOrderItemId, "userImage" => $userImage, "status" => $status, ]);
    }
    /**
     * 上传用户作品图-书册类
     */
    public static function updateUserOpusInfo (int $productOrderId, array $workImages, string $status): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateUserOpusInfo(["productOrderId" => $productOrderId, "workImages" => $workImages, "status" => $status, ]);
    }
    /**
     * 上传用户制作原图
     */
    public static function updateOriginalImage (int $productOrderItemId, int $productOrderId, int $userId, array $images): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOriginalImage(["productOrderItemId" => $productOrderItemId, "productOrderId" => $productOrderId, "userId" => $userId, "images" => $images, ]);
    }
    /**
     * 生产订单列表-分页
     */
    public static function listWithPaginator (int $id, array $ids, string $productOrderNo, array $productOrderNos, string $status, array $statusList, int $orderId, array $orderIds, int $orderItemId, array $orderItemIds, string $supplierCode, array $supplierCodes, int $export, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginator(["id" => $id, "ids" => $ids, "productOrderNo" => $productOrderNo, "productOrderNos" => $productOrderNos, "status" => $status, "statusList" => $statusList, "orderId" => $orderId, "orderIds" => $orderIds, "orderItemId" => $orderItemId, "orderItemIds" => $orderItemIds, "supplierCode" => $supplierCode, "supplierCodes" => $supplierCodes, "export" => $export, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 根据生产单ids,增加导出次数
     */
    public static function incrExportByProductOrderIds (array $productOrderIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->incrExportByProductOrderIds(["productOrderIds" => $productOrderIds, ]);
    }
    /**
     * 根据生产单子单id,查看详情
     */
    public static function detailByProductOrderItemId (int $productOrderItemId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByProductOrderItemId(["productOrderItemId" => $productOrderItemId, ]);
    }
    /**
     * 单个生产订单批量绑定快递单号
     */
    public static function createLogistics (string $productOrderNo, array $logisticsNos): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createLogistics(["productOrderNo" => $productOrderNo, "logisticsNos" => $logisticsNos, ]);
    }
    /**
     * 用户作品回调更新数据
     */
    public static function callbackProductOrderItem (string $taskId, string $type, string $outPath, string $status, string $failReason): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackProductOrderItem(["taskId" => $taskId, "type" => $type, "outPath" => $outPath, "status" => $status, "failReason" => $failReason, ]);
    }
    /**
     * 修改生产单备注
     */
    public static function editProductOrderNote (int $productOrderId, string $note): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->editProductOrderNote(["productOrderId" => $productOrderId, "note" => $note, ]);
    }
    /**
     * 自动同步到生产单数据
     */
    public static function autoCreateProductOrder (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCreateProductOrder();
    }
    /**
     * 草稿直接提交生产
     */
    public static function submitCreateProductOrder (?\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\UpdateDraftCmd $updateDraftCmd = null): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitCreateProductOrder($updateDraftCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}