<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-24 11:18:44
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Refund
 */
class Refund {
    private static string $serviceName = "RetailOrder";

    private static string $className = "Refund";

    /**
     * 退款列表
     */
    public static function list (int $orderId, array $orderIds, string $status, int $storeId, array $storeIds, int $userId, string $applyTimeStart, string $applyTimeEnd, string $processTimeStart, string $processTimeEnd, int $inputStaffId, array $afterSaleIds, array $froms, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["orderId" => $orderId, "orderIds" => $orderIds, "status" => $status, "storeId" => $storeId, "storeIds" => $storeIds, "userId" => $userId, "applyTimeStart" => $applyTimeStart, "applyTimeEnd" => $applyTimeEnd, "processTimeStart" => $processTimeStart, "processTimeEnd" => $processTimeEnd, "inputStaffId" => $inputStaffId, "afterSaleIds" => $afterSaleIds, "froms" => $froms, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 通过退款
     */
    public static function pass (int $id, string $refundNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->pass(["id" => $id, "refundNo" => $refundNo, ]);
    }
    /**
     * 拒绝退款
     */
    public static function reject (int $id, string $reason = '', int $operateId = 0): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->reject(["id" => $id, "reason" => $reason, "operateId" => $operateId, ]);
    }
    /**
     * 零售退款 - 查看详情 - 发票已处理
     */
    public static function handleInvoiceProcessed (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleInvoiceProcessed(["id" => $id, ]);
    }
    /**
     * 根据零售订单id，退款套餐中零售产品的钱，直接快速退款
     */
    public static function fastRefundRetailById (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->fastRefundRetailById(["id" => $id, ]);
    }
    /**
     * 财务已处理-处理拉卡拉异常的退款单
     */
    public static function refundAbnormalFinanceHandled (int $id, string $refundNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundAbnormalFinanceHandled(["id" => $id, "refundNo" => $refundNo, ]);
    }
    /**
     * 设置拉卡拉退款异常存疑结果为拉卡拉已经退款
     */
    public static function setPayMaxRefundSuccess (int $refundId, string $passedAt, string $refundNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPayMaxRefundSuccess(["refundId" => $refundId, "passedAt" => $passedAt, "refundNo" => $refundNo, ]);
    }
    /**
     * 退款成功通知 - 暂时无该业务
     */
    public static function refundMoneyNotice (int $refundId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundMoneyNotice(["refundId" => $refundId, ]);
    }
    /**
     * 设置抖音退款结果
     */
    public static function setDouYinRefundStatus (int $refundId, string $status): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setDouYinRefundStatus(["refundId" => $refundId, "status" => $status, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}