<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-02 15:08:48
 */
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderStatusV2Enum {
    /**
     * 已提交：提交了订单，但是还没有完全支付完成
     */
    const SUBMITTED = "submitted";
    /**
     * 支付确认中
     */
    const CONFIRMING = "confirming";
    /**
     * 已支付：订单已经完全完成支付,订单已经提货数量n（n=0）
     */
    const PAID = "paid";
    /**
     * 生产中：所有产品都已制作，但是未回传物流单号
     */
    const PRODUCED = "produced";
    /**
     * 部分发货：已回传部分产品的物流单号。当存在待制作的产品时，显示去制作按钮
     */
    const PART_SHIP = "part_ship";
    /**
     * 待收货：所有产品都已回传物流单号，但是未全部确认收货
     */
    const SHIPPED = "shipped";
    /**
     * 运送中：订单已经提货数量n（1&lt;=n&lt;N）
oms order status: 95已发货
     */
    const TRANSPORTING = "transporting";
    /**
     * 已完成:订单已经提货数量n（n=N）
oms order status: 110已完成
     */
    const FINISHED = "finished";
    /**
     * 已关闭 - 正常关闭（一般是提交订单但是没有支付的场景下关闭的）
     */
    const CLOSED = "closed";
    /**
     * 售后关闭 - 通过售后单，将所有的商品进行售后。订单商品全部都进行了售后
     */
    const AFTER_SALE_CLOSED = "after_sale_closed";
    /**
     * 财务关闭 - 财务将现金支付的订单进行手动关闭
     */
    const FINANCE_CLOSED = "finance_closed";
    /**
     * 订单未完成支付的状态
     */
    const PAID_BEFORE_STATUS = ["submitted","confirming"];
}