<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-08 16:42:29
 */
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderV2
 */
class OrderV2 {
    private static string $serviceName = "RetailOrder";

    private static string $className = "OrderV2";

    /**
     * setOrderName
     * @return  mixed
    */
    public static function setOrderName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderName();
    }
    /**
     * 创建订单
     * @return  array
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }
    /**
     * 根据订单id保存用户邮寄地址
     * @return  bool
    */
    public static function addOrderAddress (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderAddress($_params);
    }
    /**
     * 订单详情
     * @return  array
    */
    public static function detail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail($_params);
    }
    /**
     * 订单物流信息
     * @return  array
    */
    public static function orderLogistics (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogistics($_params);
    }
    /**
     * 订单列表
     * @return  array
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }
    /**
     * 用户手动关闭订单——未支付状态
     * @return  bool
    */
    public static function closeByUser (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByUser($_params);
    }
    /**
     * 自动关闭已提交但是未支付的订单
     * @return  bool
    */
    public static function closeByLimitTimeNotPaid () {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByLimitTimeNotPaid();
    }
    /**
     * 检测订单12小时制作状态是否发送短信任务
     * @return  bool
    */
    public static function judgeOrderWhetherSendSms () {
        return RpcClass::getClass(self::$serviceName, self::$className)->judgeOrderWhetherSendSms();
    }
    /**
     * 用户订单——手动收货
     * @return  bool
    */
    public static function receivedByUser (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receivedByUser($_params);
    }
    /**
     * autoTimingReceiveOrder
     * @return  bool
    */
    public static function autoTimingReceiveOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoTimingReceiveOrder();
    }
    /**
     * 对已全部发货订单，进行自动收货
     * @return  bool
    */
    public static function autoReceiveOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoReceiveOrder();
    }
    /**
     * 设置订单状态是支付确认中
     * @return  bool
    */
    public static function orderStatusConfirming (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderStatusConfirming(["id" => $id]);
    }
    /**
     * 订单列表-不带完整的订单详情信息
     * @return  array
    */
    public static function orderListWithoutDetail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderListWithoutDetail($_params);
    }
    /**
     * 订单列表-不分页
     * @return  array
    */
    public static function orderList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderList($_params);
    }
    /**
     * 订单明细-不分页
     * @return  array
    */
    public static function orderItemList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderItemList($_params);
    }
    /**
     * 修改订单状态
     * @return  bool
    */
    public static function manualChangeOrderStatus (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualChangeOrderStatus($_params);
    }
    /**
     * 根据订单id获取物流单号
     * @return  array
    */
    public static function orderLogisticsByOrderId (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogisticsByOrderId(["orderId" => $orderId]);
    }
    /**
     * 设置订单完成支付
     * @return  bool
    */
    public static function setPaid (\Mainto\Bridge\Structs\RetailOrder\Cmd\OrderSetPaidCmd $orderSetPaidCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid($orderSetPaidCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}