<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setOrderNameByParams(array $params)
 * @method createByParams(array $params)
 * @method addOrderAddressByParams(array $params)
 * @method detailByParams(array $params)
 * @method orderLogisticsByParams(array $params)
 * @method listByParams(array $params)
 * @method closeByUserByParams(array $params)
 * @method closeByLimitTimeNotPaidByParams(array $params)
 * @method judgeOrderWhetherSendSmsByParams(array $params)
 * @method receivedByUserByParams(array $params)
 * @method autoTimingReceiveOrderByParams(array $params)
 * @method autoReceiveOrderByParams(array $params)
 * @method orderStatusConfirmingByParams(array $params)
 * @method orderListWithoutDetailByParams(array $params)
 * @method orderListByParams(array $params)
 * @method orderItemListByParams(array $params)
 * @method manualChangeOrderStatusByParams(array $params)
 * @method orderLogisticsByOrderIdByParams(array $params)
 */
class OrderV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动创建下一天的零售商城初始单号(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderName () {
        return self::getClass()->setOrderName();
    }

    /**
     * 创建订单
     *
     * @support  int $userId 下单用户ID [ require false ]
     * @support  string $userName 用户名 [ require false ]
     * @support  string $userPhone 用户手机号 [ require false ]
     * @support  string $userSex 用户性别 [ require false ]
     * @support  string $userBirthday 用户生日 [ require false ]
     * @support  float $money 订单金额(商品原价总额) [ require true ]
     * @support  float $originalMoney 订单的原价总额 [ require true ]
     * @support  float $realMoney 订单实付金额(商品优惠之后的总额) [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  int $inputStaffId 售出伙伴ID [ require false ]
     * @support  string $note 备注 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $from 订单来源（pc:管理端、mobile:预约端, mall:微信商城小程序） [ require true ]
     * @support  string $source 销售来源（onlineSales:线上、offlineSales 线下、memberSales会员权益、gift赠品、customPlatform定制商城） [ require false ]
     * @support  string $isUrgent 订单是否加急（URGENT:加急、GENERAL:不加急） [ require false ]
     * @support  array $couponIds 优惠券/产品券ids [ require false ]
     * @support  array $expressInfo 物流信息 [ require false ]
     * @support  array $shopCartIds 需要删除购物车ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 根据订单id保存用户邮寄地址
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $expressInfo 物流信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addOrderAddress () {
        return self::getClass()->addOrderAddress([
        ]);
    }

    /**
     * 订单详情
     *
     * @support  int $id 订单ID [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $source 销售来源（onlineSales:线上、offlineSales 线下、memberSales会员权益、gift赠品、customPlatform定制商城） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 订单物流信息
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $itemIds 订单明细ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderLogistics () {
        return self::getClass()->orderLogistics([
        ]);
    }

    /**
     * 订单列表
     *
     * @support  int $himoOrderId 海马体订单id [ require false ]
     * @support  array $himoOrderIds 海马体订单ids [ require false ]
     * @support  string $userPhone 电话号码 [ require false ]
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $paidTimeStart 支付起始时间 [ require false ]
     * @support  string $paidTimeEnd 支付结束时间 [ require false ]
     * @support  string $userName 用户姓名 [ require false ]
     * @support  int $userId 用户userId [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $productOrderNo 生产单号 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $inputStaffId 售出伙伴ID [ require false ]
     * @support  int $invoiceId 发票id [ require false ]
     * @support  array $statusList 状态列表 [ require false ]
     * @support  string $payType 支付方式 [ require false ]
     * @support  string $from 订单业务来源 [ require false ]
     * @support  array $fromList 订单业务来源组合 [ require false ]
     * @support  string $source 下单方式来源 [ require false ]
     * @support  array $sources 下单方式来源组合 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @support  string $expressStatus 订单状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 用户手动关闭订单——未支付状态
     *
     * @support  int $userId 下单用户ID [ require true ]
     * @support  int $id 订单id [ require true ]
     * @support  string $reason 关单原因 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeByUser () {
        return self::getClass()->closeByUser([
        ]);
    }

    /**
     * 自动关闭已提交但是未支付的订单
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function closeByLimitTimeNotPaid () {
        return self::getClass()->closeByLimitTimeNotPaid();
    }

    /**
     * 检测订单12小时制作状态是否发送短信任务
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function judgeOrderWhetherSendSms () {
        return self::getClass()->judgeOrderWhetherSendSms();
    }

    /**
     * 用户订单——手动收货
     *
     * @support  int $userId 下单用户ID [ require true ]
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receivedByUser () {
        return self::getClass()->receivedByUser([
        ]);
    }

    /**
     * 每半小时自动检测订单状态，完成订单的自动确认状态；
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoTimingReceiveOrder () {
        return self::getClass()->autoTimingReceiveOrder();
    }

    /**
     * 对已全部发货订单，进行自动收货
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoReceiveOrder () {
        return self::getClass()->autoReceiveOrder();
    }

    /**
     * 目前支持的场景：from=mall, source=customPlatform
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderStatusConfirming (int $id) {
        return self::getClass()->orderStatusConfirming([
            "id" => $id,
        ]);
    }

    /**
     * 订单列表-不带完整的订单详情信息
     *
     * @support  array $ids 订单id数组 [ require false ]
     * @support  array $orderNos 订单号数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderListWithoutDetail () {
        return self::getClass()->orderListWithoutDetail([
        ]);
    }

    /**
     * 订单列表-不分页
     *
     * @support  array $ids 订单ids [ require false ]
     * @support  string $orderNo 订单编号 [ require false ]
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $userPhone 电话号码 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $from 订单来源（pc:管理端、mobile:预约端, mall:微信商城小程序） [ require false ]
     * @support  string $source 销售来源（onlineSales:线上、offlineSales 线下、memberSales会员权益、gift赠品、customPlatform定制商城） [ require false ]
     * @support  int $inputStaffId 录入人伙伴ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderList () {
        return self::getClass()->orderList([
        ]);
    }

    /**
     * 订单明细-不分页
     *
     * @support  array $orderItemIds 订单orderItemId数组 [ require false ]
     * @support  array $orderIds 订单orderItemId数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderItemList () {
        return self::getClass()->orderItemList([
        ]);
    }

    /**
     * 修改订单状态
     *
     * @support  string $status 状态 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  int $orderItemId 订单子单id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualChangeOrderStatus () {
        return self::getClass()->manualChangeOrderStatus([
        ]);
    }

    /**
     * 根据订单id获取物流单号
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderLogisticsByOrderId (int $orderId) {
        return self::getClass()->orderLogisticsByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'OrderV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'OrderV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}