<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setCompositionNoByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method listWithPaginatorByParams(array $params)
 * @method batchDeleteByParams(array $params)
 */
class Composition {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动创建下一天的用户作品初始单号(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCompositionNo () {
        return self::getClass()->setCompositionNo();
    }

    /**
     * 用户作品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 用户作品列表-不分页
     *
     * @support  int $id id [ require false ]
     * @support  array $ids id [ require false ]
     * @support  int $userId 用户userId [ require false ]
     * @support  array $userIds 用户userIds [ require false ]
     * @support  string $name 作品名称 [ require false ]
     * @support  int $productOrderId 生产订单id [ require false ]
     * @support  array $productOrderIds 生产订单ids [ require false ]
     * @support  int $productOrderItemId 生产订单itemId [ require false ]
     * @support  array $productOrderItemIds 生产订单itemIds [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 用户作品列表-分页
     *
     * @support  int $id id [ require false ]
     * @support  array $ids id [ require false ]
     * @support  int $userId 用户userId [ require false ]
     * @support  array $userIds 用户userIds [ require false ]
     * @support  string $name 作品名称 [ require false ]
     * @support  int $productOrderId 生产订单id [ require false ]
     * @support  int $productOrderIds 生产订单ids [ require false ]
     * @support  int $productOrderItemId 生产订单itemId [ require false ]
     * @support  array $productOrderItemIds 生产订单itemIds [ require false ]
     * @param  int $page 第几页 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginator (int $page, int $pageSize) {
        return self::getClass()->listWithPaginator([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除作品
     *
     * @param  array $ids 图片ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDelete (array $ids) {
        return self::getClass()->batchDelete([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Composition');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Composition');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}