<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderStatusEnum {
    /**
     * 未提交:20201111之前的业务使用，之后的业务不再使用。如果要删除这个枚举值的话，需要将 no_submit 全部修改为 submitted
     */
    const NO_SUBMIT = 'no_submit';
    /**
     * 已提交：创建了订单，但是还没有完全支付完成
     */
    const SUBMITTED = 'submitted';
    /**
     * 支付确认中：业务没有使用
     */
    const CONFIRMING = 'confirming';
    /**
     * 已支付：订单已经完全完成支付,订单已经提货数量n（n=0）
     */
    const PAID = 'paid';
    /**
     * 运送中：订单已经提货数量n（1&lt;=n&lt;N）
     */
    const TRANSPORTING = 'transporting';
    /**
     * 已完成:订单已经提货数量n（n=N）
     */
    const FINISHED = 'finished';
    /**
     * 已关闭 - 正常关闭（一般是提交订单但是没有支付的场景下关闭的）
     */
    const CLOSED = 'closed';
    /**
     * 售后关闭 - 通过售后单，将所有的商品进行售后。订单商品全部都进行了售后
     */
    const AFTER_SALE_CLOSED = 'after_sale_closed';
    /**
     * 财务关闭 - 财务将现金支付的订单进行手动关闭
     */
    const FINANCE_CLOSED = 'finance_closed';
    /**
     * 所有的订单状态
     */
    const ALL_ORDER_STATUS = [0 => 'no_submit',1 => 'submitted',2 => 'confirming',3 => 'paid',4 => 'transporting',5 => 'finished',6 => 'closed',7 => 'after_sale_closed',8 => 'finance_closed'];
    /**
     * 修改订单状态枚举
     */
    const CHANGE_ORDER_STATUS = ['paid' => [0 => 'paid'],'finished' => [0 => 'finished'],'submitted' => [0 => 'no_submit',1 => 'submitted']];
}