<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserCouponsByParams(array $params)
 * @method deleteSettingCouponByParams(array $params)
 * @method getSettingCouponListByParams(array $params)
 * @method bindUserCouponsByParams(array $params)
 * @method getCouponBySceneByParams(array $params)
 * @method bulkGenerateCouponsByParams(array $params)
 * @method getSkuEffectiveCouponsByParams(array $params)
 * @method autoGrantPayCompletedCouponByParams(array $params)
 * @method grantCouponByParams(array $params)
 * @method abolishCouponsByParams(array $params)
 * @method couponGrantRecordListByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户中心优惠券列表
     *
     * @support  int $userId 用户id [ require true ]
     * @support  array $status 优惠券状态;已激活【已激活可能还未绑定】:activated;未使用:unused;使用:used;已作废:abolished;已过期:expired; [ require false ]
     * @support  string $applyIn 应用于业务 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserCoupons () {
        return self::getClass()->getUserCoupons([
        ]);
    }

    /**
     * 删除优惠券配置信息
     *
     * @support  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteSettingCoupon () {
        return self::getClass()->deleteSettingCoupon([
        ]);
    }

    /**
     * 获取优惠券配置列表
     *
     * @support  string $type 模板类型;折扣券:discount_coupon;立减券:decrease_coupon; [ require false ]
     * @support  string $applyIn 应用于业务;零售：retail [ require false ]
     * @support  array $ids 记录ids [ require false ]
     * @support  string $createdAtEnd 创建时间止 [ require false ]
     * @support  string $createdAtStart 创建时间起 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSettingCouponList () {
        return self::getClass()->getSettingCouponList([
        ]);
    }

    /**
     * 创建绑定单个用户优惠卷
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $applyScene 应用场景 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindUserCoupons () {
        return self::getClass()->bindUserCoupons([
        ]);
    }

    /**
     * 根据应用场景获取零售优惠券展示信息
     *
     * @support  int $userId 用户id [ require false ]
     * @support  string $applyScene 应用场景 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponByScene () {
        return self::getClass()->getCouponByScene([
        ]);
    }

    /**
     * 创建优惠券
     *
     * @support  int $count 创建数量 [ require false ]
     * @support  string $title 标题 [ require true ]
     * @support  int $userId 用户ID [ require false ]
     * @support  string $applyScene 应用场景 [ require false ]
     * @support  string $status 优惠券状态；已激活【已激活可能还未绑定】:activated;未使用:unused;使用:used;已作废:abolished;已过期:expired; [ require true ]
     * @support  int $templateId 模板id [ require true ]
     * @support  string $buyChannel 购买渠道;门店团购：store_group;门店：store;BUSINESS事业部：business;总部：headquarters;个人：personal;天猫售出：tmall; [ require true ]
     * @support  float $discount 折扣｜立减金额 [ require true ]
     * @support  string $stopUsage 结束使用时间 [ require false ]
     * @support  string $startUsage 开始使用时间 [ require false ]
     * @support  string $limit 是否限制领取数量；compute：限制领取数量；infinite：不限制领取数量； [ require false ]
     * @support  string $timeType 有效期类型;free:自领取后几天内有效;appoint:指定有效日期; [ require false ]
     * @support  int $timeLong 领取后几天有效 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @support  int $createdBy 创建人 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bulkGenerateCoupons () {
        return self::getClass()->bulkGenerateCoupons([
        ]);
    }

    /**
     * 检测商品信息和优惠券信息计算优惠信息
     *
     * @support  int $userId 用户id [ require true ]
     * @support  array $products 订单故障信息 [ require true ]
     * @support  array $ids 指定优惠券ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuEffectiveCoupons () {
        return self::getClass()->getSkuEffectiveCoupons([
        ]);
    }

    /**
     * 支付完成后发放优惠券
     *
     * @support  array $order 订单数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function autoGrantPayCompletedCoupon () {
        return self::getClass()->autoGrantPayCompletedCoupon([
        ]);
    }

    /**
     * 批量发放关联优惠券
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  string $scene 场景 [ require true ]
     * @support  array $items 发券明细列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function grantCoupon () {
        return self::getClass()->grantCoupon([
        ]);
    }

    /**
     * abolishCoupons
     *
     * @support  string $scene 业务场景 [ require true ]
     * @support  int $orderId 业务方订单id [ require true ]
     * @support  array $orderItemIds 业务方订单明细ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function abolishCoupons () {
        return self::getClass()->abolishCoupons([
        ]);
    }

    /**
     * couponGrantRecordList
     *
     * @support  string $scene 业务场景 [ require true ]
     * @support  int $orderId 业务方订单id [ require false ]
     * @support  array $orderItemIds 业务方订单明细id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function couponGrantRecordList () {
        return self::getClass()->couponGrantRecordList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}