<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderPayTypeEnum {
    /**
     * 线下支付宝
     */
    const OFFLINE_ALIPAY = 'offline_alipay';
    /**
     * 线下微信
     */
    const OFFLINE_WECHAT = 'offline_wechat';
    /**
     * 现金支付
     */
    const CASH = 'cash';
    /**
     * pos机支付
     */
    const POS = 'pos';
    /**
     * 礼品卡
     */
    const GIFT_CARD = 'gift_card';
    /**
     * 企业对公账户
     */
    const ENTERPRISE = 'enterprise';
    /**
     * 商场卡：特定时间段的支付方式，已经不再使用，可以类比与现金支付，正式环境零售订单有10笔该支付方式
     */
    const MARKET_CARD = 'market_card';
    /**
     * 拉卡拉线上微信支付
     */
    const PAYMAX_WECHAT = 'paymax_wechat';
    /**
     * 拉卡拉线上支付宝支付
     */
    const PAYMAX_ALIPAY = 'paymax_alipay';
    /**
     * 拉卡拉线下支付宝支付：门店使用我们自己的拉卡拉机子，扫描用户支付宝付款码支付
     */
    const OFFLINE_PAYMAX_ALIPAY = 'offline_paymax_alipay';
    /**
     * 拉卡拉线下微信支付：门店使用我们自己的拉卡拉机子，扫描用户微信付款码支付
     */
    const OFFLINE_PAYMAX_WECHAT = 'offline_paymax_wechat';
    /**
     * 拉卡拉线下云闪付（银联）:门店使用我们自己的拉卡拉机子，扫描用户云闪付付款码支付
     */
    const OFFLINE_PAYMAX_UQRCODE = 'offline_paymax_uqrcode';
    /**
     * 拉卡拉线下银行支付：门店使用我们自己的拉卡拉机子，用户刷银行卡进行支付
     */
    const OFFLINE_PAYMAX_BANKCARD = 'offline_paymax_bankcard';
    /**
     * 小程序拉卡拉微信
     */
    const PAYMAX_WX_APP = 'paymax_wx_app';
    /**
     * 小程序拉卡拉支付宝
     */
    const PAYMAX_ALIPAY_MINI_APP = 'paymax_alipay_mini_app';
    /**
     * 零售商城0元订单
     */
    const RETAIL_MALL_ZERO = 'retail_mall_zero';
    /**
     * 抖音支付
     */
    const DOUYIN = 'douyin';
    const ALL_PAY_TYPE = [0 => 'offline_alipay',1 => 'offline_wechat',2 => 'cash',3 => 'pos',4 => 'gift_card',5 => 'enterprise',6 => 'market_card',7 => 'paymax_wechat',8 => 'paymax_alipay',9 => 'offline_paymax_alipay',10 => 'offline_paymax_wechat',11 => 'offline_paymax_uqrcode',12 => 'offline_paymax_bankcard',13 => 'paymax_wx_app',14 => 'paymax_alipay_mini_app',15 => 'retail_mall_zero',16 => 'douyin'];
    /**
     * 线下支付场景的订单支付方式
     */
    const ORDER_OFFLINE_PAY_TYPE = [0 => 'cash',1 => 'offline_alipay',2 => 'offline_wechat',3 => 'pos',4 => 'enterprise'];
}