<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method pullSyncByParams(array $params)
 * @method handlePullOrderByParams(array $params)
 * @method handlePullRefundByParams(array $params)
 * @method getExceptionOrderListByParams(array $params)
 */
class Oms {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 定时拉取Oms平台的零售订单相关信息，半个小时拉取一次
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $omsOrderNo oms订单编号 [ require false ]
     * @support  string $omsRefundNo oms退款单编号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pullSync () {
        return self::getClass()->pullSync([
        ]);
    }

    /**
     * 处理 oms 订单同步数据
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function handlePullOrder () {
        return self::getClass()->handlePullOrder();
    }

    /**
     * 处理 oms 订单同步数据
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function handlePullRefund () {
        return self::getClass()->handlePullRefund();
    }

    /**
     * oms 异常单列表
     *
     * @param  string $omsOrderNo oms订单编号 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExceptionOrderList (string $omsOrderNo = '', int $page = 1, int $pageSize = 50) {
        return self::getClass()->getExceptionOrderList([
            "omsOrderNo" => $omsOrderNo,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Oms');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Oms');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}