<?php
namespace Mainto\Bridge\Invokes\RetailOrder\Composition;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\CreateDraftCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\UpdateDraftCmd $params)
 * @method deleteByParams(array|\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\DelDraftCmd $params)
 * @method getDetailByParams(array|\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftDetailCmd $params)
 * @method getListWithPaginatorByParams(array|\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftListWithPaginatorCmd $params)
 * @method getListByParams(array|\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftListCmd $params)
 */
class Draft {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建作品草稿
     *
     * @var  \Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\CreateDraftCmd $createDraftCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftDto
     */
    public static function create (\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\CreateDraftCmd $createDraftCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($createDraftCmd),
            "\Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftDto"
        );
    }


    /**
     * 创建作品草稿
     *
     * @var  \Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\UpdateDraftCmd $updateDraftCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\UpdateDraftCmd $updateDraftCmd) {
        return self::getClass()->update($updateDraftCmd);
    }


    /**
     * 创建作品草稿
     *
     * @var  \Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\DelDraftCmd $delDraftCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\DelDraftCmd $delDraftCmd) {
        return self::getClass()->delete($delDraftCmd);
    }


    /**
     * 创建作品草稿
     *
     * @var  \Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftDetailCmd $getDraftDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftDto
     */
    public static function getDetail (\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftDetailCmd $getDraftDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDetail($getDraftDetailCmd),
            "\Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftDto"
        );
    }


    /**
     * 创建作品草稿列表-分页
     *
     * @var  \Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftListWithPaginatorCmd $getDraftListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftListWithPaginatorDto
     */
    public static function getListWithPaginator (\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftListWithPaginatorCmd $getDraftListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getListWithPaginator($getDraftListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftListWithPaginatorDto"
        );
    }


    /**
     * 创建作品草稿列表
     *
     * @var  \Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftListCmd $getDraftListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftDto[]
     */
    public static function getList (\Mainto\Bridge\Structs\RetailOrder\Composition\Cmd\Draft\GetDraftListCmd $getDraftListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList($getDraftListCmd),
            "\Mainto\Bridge\Structs\RetailOrder\Composition\DTO\Draft\DraftDto[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Composition\Draft');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Composition\Draft');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}