<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method handleInvoiceProcessedByParams(array $params)
 * @method fastRefundRetailByIdByParams(array $params)
 * @method refundAbnormalFinanceHandledByParams(array $params)
 * @method setPayMaxRefundSuccessByParams(array $params)
 * @method refundMoneyNoticeByParams(array $params)
 * @method setDouYinRefundStatusByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款列表
     *
     * @support  int $orderId 零售订单id [ require false ]
     * @support  array $orderIds 零售订单id数组 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  array $storeIds 查询门店数组 [ require false ]
     * @support  int $userId 退款用户id [ require false ]
     * @support  string $applyTimeStart 申请时间-开始 [ require false ]
     * @support  string $applyTimeEnd 申请时间-结束 [ require false ]
     * @support  string $processTimeStart 处理时间-开始 [ require false ]
     * @support  string $processTimeEnd 处理时间-结束 [ require false ]
     * @support  int $inputStaffId 售出员工ID [ require false ]
     * @support  array $afterSaleIds 售后单id数组 [ require false ]
     * @support  array $froms 售后单来源:user用户，manager管理端, oms [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $pageSize  [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function pass (int $id, int $operateId = 0) {
        return self::getClass()->pass([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $reason 拒绝原因 [ require false ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function reject (int $id, string $reason = '', int $operateId = 0) {
        return self::getClass()->reject([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 零售退款 - 查看详情 - 发票已处理
     *
     * @param  int $id 退款单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function handleInvoiceProcessed (int $id) {
        return self::getClass()->handleInvoiceProcessed([
            "id" => $id,
        ]);
    }

    /**
     * 根据零售订单id，退款套餐中零售产品的钱，直接快速退款
     *
     * @param  int $id 零售订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function fastRefundRetailById (int $id) {
        return self::getClass()->fastRefundRetailById([
            "id" => $id,
        ]);
    }

    /**
     * 财务已处理-处理拉卡拉异常的退款单
     *
     * @param  int $id 退款单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundAbnormalFinanceHandled (int $id) {
        return self::getClass()->refundAbnormalFinanceHandled([
            "id" => $id,
        ]);
    }

    /**
     * 设置拉卡拉退款异常存疑结果为拉卡拉已经退款
     *
     * @param  int $refundId 退款单id [ require true ]
     * @param  string $passedAt 退款通过时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setPayMaxRefundSuccess (int $refundId, string $passedAt) {
        return self::getClass()->setPayMaxRefundSuccess([
            "refundId" => $refundId,
            "passedAt" => $passedAt,
        ]);
    }

    /**
     * 退款成功通知
     *
     * @param  int $refundId 退款单信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundMoneyNotice (int $refundId) {
        return self::getClass()->refundMoneyNotice([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 设置抖音退款结果
     *
     * @param  int $refundId 退款单id [ require true ]
     * @param  string $status 退款单id状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setDouYinRefundStatus (int $refundId, string $status) {
        return self::getClass()->setDouYinRefundStatus([
            "refundId" => $refundId,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}