<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class MessageQueueNameEnum {
    /**
     * 零售售后退款
     */
    const AFTER_SALE_REFUND = 'RetailOrder.AfterSale.Refund';
    /**
     * 零售抖音订单，零售售后退款，向聚合订单发送创建退款单
     */
    const AFTER_SALE_DOUYIN_REFUND_CREATE = 'RetailOrder.AfterSale.DouyinRefund.Create';
    /**
     * 零售抖音订单，订单状态变更，向聚合订单发送订单状态变更
     */
    const ORDER_STATUS_CHANGE = 'RetailOrder.Order.DouyinOrderStatusChange';
    /**
     * 零售抖音订单，订单状态变更，向聚合订单发送订单提货
     */
    const DOUYIN_ORDER_EXPRESS_FINISH = 'RetailOrder.Order.DouyinOrderExpress.Finish';
    /**
     * 零售抖音订单，订单状态变更，向聚合订单发送订单撤销提货
     */
    const DOUYIN_ORDER_EXPRESS_CANCEL = 'RetailOrder.Order.DouyinOrderExpress.Cancel';
    /**
     * 零售订单：会员积分
     */
    const ORDER_CREATE_USER_FLOW = 'order:create_user_flow';
    /**
     * 零售订单：支付后业务逻辑回写
     */
    const ORDER_AFTER_PAY = 'retailOrder:order_after_pay';
    /**
     * 零售订单：退款成功通知
     */
    const AFTER_SALE_REFUND_SUCCESS = 'RetailOrder:AfterSale.RefundSuccess';
    /**
     * 零售抖音订单退款结果回调
     */
    const AFTER_SALE_DOUYIN_REFUND_STATUS_CALL_BACK = 'ProjectRetail.AfterSale.DouYinRefundStatus.CallBack';
}