<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderSourceEnum {
    /**
     * 预约端
     */
    const ONLINE_SALES = 'onlineSales';
    /**
     * 门店
     */
    const OFFLINE_SALES = 'offlineSales';
    /**
     * 会员权益
     */
    const MEMBER_SALES = 'memberSales';
    /**
     * 定制平台
     */
    const CUSTOM_PLATFORM = 'customPlatform';
    /**
     * 赠品
     */
    const MEMBER_GIFT = 'gift';
    /**
     * 有赞线上商店：youzan
     */
    const YOUZAN = 'youzan';
    /**
     * 天猫企业购: tmall
     */
    const TMALL = 'tmall';
    /**
     * 淘宝: taobao
     */
    const TAOBAO = 'taobao';
    /**
     * 线下，这个比较特殊，一般业务人员自己录入用于调度的订单：offline
     */
    const OFFLINE = 'offline';
    /**
     * 所有下单方式来源
     */
    const ALL_SOURCE_STATUS = [0 => 'onlineSales',1 => 'offlineSales',2 => 'memberSales',3 => 'customPlatform',4 => 'gift',5 => 'youzan',6 => 'tmall',7 => 'taobao',8 => 'offline'];
}