<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\RetailOrder\Cmd\CreateOrderCmd $params)
 * @method detailByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method listByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method orderAfterPayByParams(array $params)
 * @method closeByParams(array $params)
 * @method closeWithPushByParams(array $params)
 * @method authCloseNoPayOrderByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getPriceInfoByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method modifyOrderInputStaffIdByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method listInOrdersByParams(array $params)
 * @method getStaffRetailEffectByParams(array $params)
 * @method closeByHimoOrderIdByParams(array $params)
 * @method orderItemsFinishExpressByParams(array $params)
 * @method orderIdBatchFinishExpressByParams(array $params)
 * @method orderItemsBatchFinishExpressByParams(array $params)
 * @method orderItemsCancelExpressByParams(array $params)
 * @method orderItemsBatchCancelExpressByParams(array $params)
 * @method setOrderNameByParams(array $params)
 * @method closeByPaidByParams(array $params)
 * @method changeOrderStatusByParams(array $params)
 * @method giftCardPayWithholdByParams(array $params)
 * @method giftCardSubmitPrePayByParams(array $params)
 * @method cancelGiftCardPrePayByParams(array $params)
 * @method getOrderGiftCardInfoByParams(array $params)
 * @method getOrderLogsByParams(array $params)
 * @method getOrderByIdByParams(array $params)
 * @method getOrderWithItemByIdByParams(array $params)
 * @method getRefundWithOrderByOrderNoByParams(array $params)
 * @method refundForMemberByParams(array $params)
 * @method modifyOrderStoreHimoOrderByParams(array $params)
 * @method modifyOrderStaffIdByOrderNoByParams(array $params)
 * @method getOrderItemsByOrderItemIdsByParams(array $params)
 * @method skuDiscountExcessNoticeByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售订单
     *
     * @var  \Mainto\Bridge\Structs\RetailOrder\Cmd\CreateOrderCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function create (\Mainto\Bridge\Structs\RetailOrder\Cmd\CreateOrderCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * 订单详情
     *
     * @support  int $id 订单ID [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  int $himoOrderId 海马体订单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 修改订单支付方式
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require false ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changePayType (int $id, string $payType, string $paymentNo = '', int $operateId = 0) {
        return self::getClass()->changePayType([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 订单列表
     *
     * @support  int $himoOrderId 海马体订单id [ require false ]
     * @support  array $himoOrderIds 海马体订单ids [ require false ]
     * @support  string $userPhone 电话号码 [ require false ]
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $paidTimeStart 支付起始时间 [ require false ]
     * @support  string $paidTimeEnd 支付结束时间 [ require false ]
     * @support  string $userName 用户姓名 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $inputStaffId 售出伙伴ID [ require false ]
     * @support  int $invoiceId 发票id [ require false ]
     * @support  array $statusList 状态列表 [ require false ]
     * @support  string $payType 支付方式 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 页内条数 [ require false ]
     * @support  string $expressStatus 订单状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $himoOrderId 海马体订单id [ require false ]
     * @param  float $money 订单金额 [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  int $inputStaffId 售出伙伴ID [ require false ]
     * @param  string $paymentNo 支付流水号 [ require false ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @param  string $certificate 支付凭证 [ require false ]
     * @param  string $paymentTime 对公打款时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaid (int $id, float $money, string $payType, int $inputStaffId = 0, string $paymentNo = '', string $certificate = '', string $paymentTime = '', int $operateId = 0, int $himoOrderId = 0) {
        return self::getClass()->setPaid([
            "id" => $id,
            "money" => $money,
            "payType" => $payType,
            "inputStaffId" => $inputStaffId,
            "paymentNo" => $paymentNo,
            "certificate" => $certificate,
            "paymentTime" => $paymentTime,
            "operateId" => $operateId,
            "himoOrderId" => $himoOrderId,
        ]);
    }

    /**
     * 订单支付成功后续处理
     *
     * @param  array $order 订单信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderAfterPay (array $order) {
        return self::getClass()->orderAfterPay([
            "order" => $order,
        ]);
    }

    /**
     * 关闭订单——未支付的零售订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $id, string $reason, int $operateId = 0) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 关闭订单——未完成支付的零售订单包含处理礼品卡预支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeWithPush (int $id, string $reason, int $operateId = 0) {
        return self::getClass()->closeWithPush([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 每天定时关闭未支付的门店订单
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function authCloseNoPayOrder () {
        return self::getClass()->authCloseNoPayOrder();
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $orderNo) {
        return self::getClass()->getIdByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单号获取订单最大开票金额
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPriceInfoByNo (string $orderNo) {
        return self::getClass()->getPriceInfoByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 修改零售订单关联销售人员
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $inputStaffId 售出伙伴ID [ require false ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyOrderInputStaffId (int $id, int $inputStaffId = 0, int $operateId = 0) {
        return self::getClass()->modifyOrderInputStaffId([
            "id" => $id,
            "inputStaffId" => $inputStaffId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 设置服务完成
     *
     * @param  int $id id [ require true ]
     * @param  bool $isUserComplete 是否是用户确认 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function serviceComplete (int $id, bool $isUserComplete = true) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "isUserComplete" => $isUserComplete,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoiceId 发票ID [ require true ]
     * @param  array $orderNos 订单号数组 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoiceId, array $orderNos, int $operateId) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoiceId" => $invoiceId,
            "orderNos" => $orderNos,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据订单号批量获取订单信息
     *
     * @support  array $himoOrderIds 海马体订单ID数组 [ require false ]
     * @support  array $orderNos 订单号数组 [ require false ]
     * @support  array $ids 订单ID数组 [ require false ]
     * @support  array $userIds 用户id数组 [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listInOrders () {
        return self::getClass()->listInOrders([
        ]);
    }

    /**
     * 获取伙伴时间范围内累积零售产品销售
     *
     * @param  int $staffId 伙伴工号 [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffRetailEffect (int $staffId, string $startTime, string $endTime) {
        return self::getClass()->getStaffRetailEffect([
            "staffId" => $staffId,
            "startTime" => $startTime,
            "endTime" => $endTime,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $himoOrderId 海马体订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeByHimoOrderId (int $himoOrderId, string $reason) {
        return self::getClass()->closeByHimoOrderId([
            "himoOrderId" => $himoOrderId,
            "reason" => $reason,
        ]);
    }

    /**
     * 设置订单商品完成自提
     *
     * @param  int $itemId 订单ItemId [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderItemsFinishExpress (int $itemId, int $storeId) {
        return self::getClass()->orderItemsFinishExpress([
            "itemId" => $itemId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 根据订单id完成批量自提
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderIdBatchFinishExpress (int $orderId, int $storeId) {
        return self::getClass()->orderIdBatchFinishExpress([
            "orderId" => $orderId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 批量设置订单商品完成自提
     *
     * @param  array $itemIds 订单ItemIds [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderItemsBatchFinishExpress (array $itemIds, int $storeId) {
        return self::getClass()->orderItemsBatchFinishExpress([
            "itemIds" => $itemIds,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 取消订单商品完成自提状态
     *
     * @param  int $itemId 订单ItemId [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderItemsCancelExpress (int $itemId, int $storeId) {
        return self::getClass()->orderItemsCancelExpress([
            "itemId" => $itemId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 批量取消订单商品完成自提状态
     *
     * @param  array $itemIds 订单ItemIds [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderItemsBatchCancelExpress (array $itemIds, int $storeId) {
        return self::getClass()->orderItemsBatchCancelExpress([
            "itemIds" => $itemIds,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 自动修改活动的状态(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderName () {
        return self::getClass()->setOrderName();
    }

    /**
     * 关闭订单——已支付的零售订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeByPaid (int $id, string $reason, int $operateId = 0) {
        return self::getClass()->closeByPaid([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改订单的状态-bms有改业务在使用
     *
     * @param  int $id id [ require true ]
     * @param  string $status 订单状态: submitted(未支付)，paid(已支付) [ require true ]
     * @param  int $operateId 录入伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeOrderStatus (int $id, string $status, int $operateId) {
        return self::getClass()->changeOrderStatus([
            "id" => $id,
            "status" => $status,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 进行礼品卡预扣（更新礼品卡金额useGiftCardMoney和预扣giftCardPrePay合并）
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardPayMoney 礼品卡金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function giftCardPayWithhold (int $id, float $giftCardPayMoney) {
        return self::getClass()->giftCardPayWithhold([
            "id" => $id,
            "giftCardPayMoney" => $giftCardPayMoney,
        ]);
    }

    /**
     * 对应已经使用礼品卡支付的订单，完成支付后，礼品卡暂扣金额进行实际扣除
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function giftCardSubmitPrePay (int $id) {
        return self::getClass()->giftCardSubmitPrePay([
            "id" => $id,
        ]);
    }

    /**
     * 对应已经使用礼品卡预支付的订单，撤销预支付
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $giftCardPaymentNo 礼品卡暂付流水号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelGiftCardPrePay (int $id, string $giftCardPaymentNo) {
        return self::getClass()->cancelGiftCardPrePay([
            "id" => $id,
            "giftCardPaymentNo" => $giftCardPaymentNo,
        ]);
    }

    /**
     * 通过订单id查询用户是否使用了礼品卡暂扣，以及暂扣了多少
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderGiftCardInfo (int $orderId) {
        return self::getClass()->getOrderGiftCardInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 通过订单id查询操作日志
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderLogs (int $orderId) {
        return self::getClass()->getOrderLogs([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 通过订单id查询Order
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderById (int $id) {
        return self::getClass()->getOrderById([
            "id" => $id,
        ]);
    }

    /**
     * 通过订单id查询Order和子订单信息
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderWithItemById (int $id) {
        return self::getClass()->getOrderWithItemById([
            "id" => $id,
        ]);
    }

    /**
     * 根据零售定单号获取未拒绝的退款金额
     *
     * @param  string $orderNo 零售订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRefundWithOrderByOrderNo (string $orderNo) {
        return self::getClass()->getRefundWithOrderByOrderNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 退单关单——给0元单使用
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundForMember (int $id, string $reason, int $operateId = 0) {
        return self::getClass()->refundForMember([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改订单归属门店和拍摄订单
     *
     * @support  int $orderId 订单ID [ require false ]
     * @support  int $himoOrderId 海马体拍摄订单id [ require true ]
     * @support  int $newStoreId 更换新的门店ID [ require true ]
     * @support  int $newHimoOrderId 更换新的海马体拍摄订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyOrderStoreHimoOrder () {
        return self::getClass()->modifyOrderStoreHimoOrder([
        ]);
    }

    /**
     * 根据订单编号修改售出伙伴id
     *
     * @param  string $orderNo 零售订单号 [ require true ]
     * @param  int $inputStaffId 售出伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyOrderStaffIdByOrderNo (string $orderNo, int $inputStaffId) {
        return self::getClass()->modifyOrderStaffIdByOrderNo([
            "orderNo" => $orderNo,
            "inputStaffId" => $inputStaffId,
        ]);
    }

    /**
     * 根据orderItemIds获取orderItems
     *
     * @param  array $orderItemIds 订单orderItemIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderItemsByOrderItemIds (array $orderItemIds) {
        return self::getClass()->getOrderItemsByOrderItemIds([
            "orderItemIds" => $orderItemIds,
        ]);
    }

    /**
     * sku 优惠价格低于吊牌价4折发起通知
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function skuDiscountExcessNotice () {
        return self::getClass()->skuDiscountExcessNotice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}