<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderPayTypeEnum {
    /**
     * 线下支付宝:有些商场只能使用商场自己的pos机，不能使用我们总部发过去的拉卡拉pos机，用户使用”支付宝”在商场的pos机支付后，门店人员选择对应的支付方式（线下支付宝）录入该订单的支付方式
     */
    const ALIPAY = 'alipay';
    /**
     * 线下微信：有些商场只能使用商场自己的pos机，不能使用我们总部发过去的拉卡拉pos机，用户使用”微信”在商场的pos机支付后，门店人员选择对应的支付方式（线下微信）录入该订单的支付方式
     */
    const WECHAT = 'wechat';
    /**
     * 工商银行微信：group_buy
     */
    const ICBC_WECHAT = 'icbc_wechat';
    /**
     * 线下支付宝
     */
    const OFFLINE_ALIPAY = 'offline_alipay';
    /**
     * 线下微信
     */
    const OFFLINE_WECHAT = 'offline_wechat';
    /**
     * 现金支付
     */
    const CASH = 'cash';
    /**
     * 团购：零售业务没有使用
     */
    const GROUP_BUY = 'group_buy';
    /**
     * 大众和美团：零售业务没有使用
     */
    const MEITUAN_DIANPING = 'meituan_dianping';
    /**
     * 百度糯米：零售业务没有使用
     */
    const NUOMI = 'nuomi';
    /**
     * pos机支付
     */
    const POS = 'pos';
    /**
     * 礼品卡
     */
    const GIFT_CARD = 'gift_card';
    /**
     * 企业对公账户
     */
    const ENTERPRISE = 'enterprise';
    /**
     * 商场卡：特定时间段的支付方式，已经不再使用，可以类比与现金支付，正式环境零售订单有10笔该支付方式
     */
    const MARKET_CARD = 'market_card';
    /**
     * 拉卡拉线上微信支付
     */
    const PAYMAX_WECHAT = 'paymax_wechat';
    /**
     * 拉卡拉线上支付宝支付
     */
    const PAYMAX_ALIPAY = 'paymax_alipay';
    /**
     * 拉卡拉线下支付宝支付：门店使用我们自己的拉卡拉机子，扫描用户支付宝付款码支付
     */
    const OFFLINE_PAYMAX_ALIPAY = 'offline_paymax_alipay';
    /**
     * 拉卡拉线下微信支付：门店使用我们自己的拉卡拉机子，扫描用户微信付款码支付
     */
    const OFFLINE_PAYMAX_WECHAT = 'offline_paymax_wechat';
    /**
     * 拉卡拉线下云闪付（银联）:门店使用我们自己的拉卡拉机子，扫描用户云闪付付款码支付
     */
    const OFFLINE_PAYMAX_UQRCODE = 'offline_paymax_uqrcode';
    /**
     * 拉卡拉线下银行支付：门店使用我们自己的拉卡拉机子，用户刷银行卡进行支付
     */
    const OFFLINE_PAYMAX_BANKCARD = 'offline_paymax_bankcard';
    /**
     * 口碑：业务没有使用
     */
    const KOUBEI = 'koubei';
    /**
     * 小程序拉卡拉微信
     */
    const PAYMAX_WX_APP = 'paymax_wx_app';
    /**
     * 小程序拉卡拉支付宝
     */
    const PAYMAX_ALIPAY_MINI_APP = 'paymax_alipay_mini_app';
    /**
     * 零售商城0元订单
     */
    const RETAIL_MALL_ZERO = 'retail_mall_zero';
    const ALL_PAY_TYPE = [0 => 'alipay',1 => 'wechat',2 => 'icbc_wechat',3 => 'offline_alipay',4 => 'offline_wechat',5 => 'cash',6 => 'group_buy',7 => 'meituan_dianping',8 => 'nuomi',9 => 'pos',10 => 'gift_card',11 => 'enterprise',12 => 'market_card',13 => 'paymax_wechat',14 => 'paymax_alipay',15 => 'offline_paymax_alipay',16 => 'offline_paymax_wechat',17 => 'offline_paymax_uqrcode',18 => 'offline_paymax_bankcard',19 => 'koubei',20 => 'paymax_wx_app',21 => 'paymax_alipay_mini_app',22 => 'retail_mall_zero'];
    /**
     * 线下支付场景的订单支付方式
     */
    const ORDER_OFFLINE_PAY_TYPE = [0 => 'cash',1 => 'offline_alipay',2 => 'offline_wechat',3 => 'pos',4 => 'enterprise'];
}