<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method listWithPaginatorByParams(array $params)
 */
class OrderItemLogistics {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建物流信息记录
     *
     * @support  int $orderId 销售订单id [ require false ]
     * @support  int $orderItemId 销售订单子表id [ require false ]
     * @support  int $productOrderId 生产订单id [ require false ]
     * @support  int $productOrderItemId 生产订单子表id [ require false ]
     * @support  string $logisticsNo 物流编号 [ require false ]
     * @support  string $source 配送物流商 [ require false ]
     * @support  array $logisticsInfo 物流信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 物流记录列表-不分页
     *
     * @support  int $id id [ require false ]
     * @support  array $ids ids [ require false ]
     * @support  int $orderId 销售订单id [ require false ]
     * @support  array $orderIds 销售订单ids [ require false ]
     * @support  int $orderItemId 销售订单子表id [ require false ]
     * @support  array $orderItemIds 销售订单子表ids [ require false ]
     * @support  int $productOrderId 生产订单id [ require false ]
     * @support  array $productOrderIds 生产订单ids [ require false ]
     * @support  int $productOrderItemId 生产订单子表id [ require false ]
     * @support  array $productOrderItemIds 生产订单子表ids [ require false ]
     * @support  string $logisticsNo 物流编号 [ require false ]
     * @support  array $logisticsNos 物流编号数组 [ require false ]
     * @support  string $source 配送物流商 [ require false ]
     * @support  array $sources 配送物流商数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 物流记录列表-分页
     *
     * @support  int $id id [ require false ]
     * @support  array $ids ids [ require false ]
     * @support  int $orderId 销售订单id [ require false ]
     * @support  array $orderIds 销售订单ids [ require false ]
     * @support  int $orderItemId 销售订单子表id [ require false ]
     * @support  array $orderItemIds 销售订单子表ids [ require false ]
     * @support  int $productOrderId 生产订单id [ require false ]
     * @support  array $productOrderIds 生产订单ids [ require false ]
     * @support  int $productOrderItemId 生产订单子表id [ require false ]
     * @support  array $productOrderItemIds 生产订单子表ids [ require false ]
     * @support  string $logisticsNo 物流编号 [ require false ]
     * @support  array $logisticsNos 物流编号数组 [ require false ]
     * @support  string $source 配送物流商 [ require false ]
     * @support  array $sources 配送物流商数组 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginator () {
        return self::getClass()->listWithPaginator([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'OrderItemLogistics');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'OrderItemLogistics');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}