<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method pullOrderByParams(array $params)
 * @method pullAfterSaleByParams(array $params)
 * @method queryOmsOrderByOmsOrderNoByParams(array $params)
 * @method queryOrderByParams(array $params)
 * @method queryRefundByParams(array $params)
 * @method omsOrderListByParams(array $params)
 * @method omsRefundListByParams(array $params)
 */
class Oms {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 定时拉取Oms平台的零售订单相关信息，半个小时拉取一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function pullOrder () {
        return self::getClass()->pullOrder();
    }

    /**
     * 定时拉取Oms平台的售后相关信息，半个小时拉取一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function pullAfterSale () {
        return self::getClass()->pullAfterSale();
    }

    /**
     * queryOmsOrderByOmsOrderNo
     *
     * @param  string $omsOrderNo oms订单编号 [ require true ]
     * @param  int $reatailOrderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryOmsOrderByOmsOrderNo (string $omsOrderNo, int $reatailOrderId) {
        return self::getClass()->queryOmsOrderByOmsOrderNo([
            "omsOrderNo" => $omsOrderNo,
            "reatailOrderId" => $reatailOrderId,
        ]);
    }

    /**
     * queryOrder
     *
     * @throws  \Exception
     * @return  array
     */
    public static function queryOrder () {
        return self::getClass()->queryOrder();
    }

    /**
     * queryRefund
     *
     * @throws  \Exception
     * @return  array
     */
    public static function queryRefund () {
        return self::getClass()->queryRefund();
    }

    /**
     * omsOrderList
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function omsOrderList () {
        return self::getClass()->omsOrderList();
    }

    /**
     * omsRefundList
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function omsRefundList () {
        return self::getClass()->omsRefundList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Oms');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Oms');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}