<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderStatusV2Enum {
    /**
     * 未提交:20201111之前的业务使用，之后的业务不再使用.
     */
    const NO_SUBMIT = 'no_submit';
    /**
     * 已提交：提交了订单，但是还没有完全支付完成
     */
    const SUBMITTED = 'submitted';
    /**
     * 支付确认中
     */
    const CONFIRMING = 'confirming';
    /**
     * 已支付：订单已经完全完成支付,订单已经提货数量n（n=0）
     */
    const PAID = 'paid';
    /**
     * 部分制作：已完成支付，其中有部分已制作的产品，有部分未制作的产品
     */
    const PART_PRODUCE = 'part_produce';
    /**
     * 生产中：所有产品都已制作，但是未回传物流单号
     */
    const PRODUCED = 'produced';
    /**
     * 部分发货：已回传部分产品的物流单号。当存在待制作的产品时，显示去制作按钮
     */
    const PART_SHIP = 'part_ship';
    /**
     * 待收货：所有产品都已回传物流单号，但是未全部确认收货
     */
    const SHIPPED = 'shipped';
    /**
     * 运送中：订单已经提货数量n（1&lt;=n&lt;N）
oms order status: 95已发货
     */
    const TRANSPORTING = 'transporting';
    /**
     * 已完成:订单已经提货数量n（n=N）
oms order status: 110已完成
     */
    const FINISHED = 'finished';
    /**
     * 已关闭 - 正常关闭（一般是提交订单但是没有支付的场景下关闭的）
     */
    const CLOSED = 'closed';
    /**
     * 售后关闭 - 通过售后单，将所有的商品进行售后。订单商品全部都进行了售后
     */
    const AFTER_SALE_CLOSED = 'after_sale_closed';
    /**
     * 财务关闭 - 财务将现金支付的订单进行手动关闭
     */
    const FINANCE_CLOSED = 'finance_closed';
    /**
     * 已取消: 业务中没有使用
     */
    const CANCELED = 'canceled';
    /**
     * oms order status: 50已递交仓库
     */
    const SUBMITTED_TO_WAREHOUSE = 'submitted_warehouse';
    /**
     * oms order status: 53未确认
     */
    const WAREHOUSE_UNCONFIRMED = 'warehouse_unconfirmed';
    /**
     * oms order status: 55已确认(已审核)
     */
    const WAREHOUSE_CONFIRMED = 'warehouse_confirmed';
    /**
     * oms order status: 113异常发货
     */
    const ABNORMAL_SHIP = 'abnormal_ship';
    /**
     * 订单未完成支付的状态
     */
    const PAID_BEFORE_STATUS = [0 => 'submitted',1 => 'confirming'];
}