<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindStaffIdByParams(array $params)
 * @method getStaffIdByUserIdByParams(array $params)
 * @method getUserIdsByStaffIdByParams(array $params)
 */
class Distribution {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户id通过分销功能绑定员工id
     *
     * @support  int $userId 用户id [ require true ]
     * @support  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindStaffId () {
        return self::getClass()->bindStaffId();
    }

    /**
     * 根据用户id获取绑定员工id
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdByUserId (int $userId) {
        return self::getClass()->getStaffIdByUserId([
            "userId" => $userId,
        ]);
    }

    /**
     * 根据员工id获取绑定用户id列表
     *
     * @param  int $staffId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserIdsByStaffId (int $staffId) {
        return self::getClass()->getUserIdsByStaffId([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Distribution');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Distribution');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}