<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class RefundPayTypeEnum {
    /**
     * 退款返还方式:礼品卡
     */
    const GIFT_CARD = 'gift_card';
    /**
     * 退款返还方式:拉卡拉，此枚举不用于具体的明细展示，只是后端用于区分拉卡拉退款
20200309 这个枚举值后面需要抽离出去
     */
    const PAY_MAX = 'pay_max';
    /**
     * 退款返还方式：支付宝，使用场景是财务进行手动退款
     */
    const FINANCE_ALIPAY = 'finance_alipay';
    /**
     * 企业对公账户
     */
    const ENTERPRISE = 'enterprise';
    /**
     * 拉卡拉线上微信支付
     */
    const PAYMAX_WECHAT = 'paymax_wechat';
    /**
     * 拉卡拉线上支付宝支付
     */
    const PAYMAX_ALIPAY = 'paymax_alipay';
    /**
     * 拉卡拉线下支付宝支付
     */
    const OFFLINE_PAYMAX_ALIPAY = 'offline_paymax_alipay';
    /**
     * 拉卡拉线下微信支付
     */
    const OFFLINE_PAYMAX_WECHAT = 'offline_paymax_wechat';
    /**
     * 拉卡拉线下银行支付
     */
    const OFFLINE_PAYMAX_BANKCARD = 'offline_paymax_bankcard';
    /**
     * 线下支付宝
     */
    const OFFLINE_ALIPAY = 'offline_alipay';
    /**
     * 线下微信
     */
    const OFFLINE_WECHAT = 'offline_wechat';
    /**
     * 现金支付
     */
    const CASH = 'cash';
    /**
     * pos机支付
     */
    const POS = 'pos';
    /**
     * 小程序拉卡拉微信
     */
    const PAYMAX_WX_APP = 'paymax_wx_app';
    /**
     * 小程序拉卡拉支付宝
     */
    const PAYMAX_ALIPAY_MINI_APP = 'paymax_alipay_mini_app';
    /**
     * 商场卡
     */
    const MARKET_CARD = 'market_card';
    /**
     * 所有拉卡拉的支付方式
     */
    const ALL_PAY_MAX_PAY_TYPE = [0 => 'paymax_wechat',1 => 'paymax_alipay',2 => 'offline_paymax_alipay',3 => 'offline_paymax_wechat',4 => 'offline_paymax_bankcard',5 => 'paymax_wx_app',6 => 'paymax_alipay_mini_app'];
    /**
     * 零售退款需要走人工退款的方式
     */
    const ALL_MANUAL_REFUND_PAY_TYPE = [0 => 'cash',1 => 'offline_wechat',2 => 'offline_alipay',3 => 'pos',4 => 'market_card'];
    /**
     * 退款单创建顺序配置
     */
    const REFUND_PAY_TYPE_SEQUENCE = [0 => 'gift_card',1 => 'paymax_wechat',2 => 'paymax_alipay',3 => 'offline_paymax_alipay',4 => 'offline_paymax_wechat',5 => 'offline_paymax_bankcard',6 => 'paymax_wx_app',7 => 'paymax_alipay_mini_app',8 => 'enterprise',9 => 'cash',10 => 'offline_wechat',11 => 'offline_alipay',12 => 'pos',13 => 'market_card'];
    /**
     * 自动退款方式执行的优先级从高到低配置
因为拉卡拉退款需要和拉卡拉服务通信，可能退款失败。所以业务上先把拉卡拉退款完成后再进行礼品卡退款
目前自动退款时，自动退款方式执行的优先级从高到低：拉卡拉（n种） &gt; 礼品卡
     */
    const AUTO_REFUND_EXECUTE_SEQUENCE = [0 => 'paymax_wechat',1 => 'paymax_alipay',2 => 'offline_paymax_alipay',3 => 'offline_paymax_wechat',4 => 'offline_paymax_bankcard',5 => 'paymax_wx_app',6 => 'paymax_alipay_mini_app',7 => 'gift_card'];
}