<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setProductOrderNameByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method callBackProductStatusChangeByParams(array $params)
 * @method getEditorJumpParamsByParams(array $params)
 * @method getOutTemplateBySkuIdByParams(array $params)
 * @method setUserCompositionThumbnailByParams(array $params)
 * @method listByParams(array $params)
 * @method updateUserImageInfoByParams(array $params)
 * @method listWithPaginatorByParams(array $params)
 * @method incrExportByProductOrderIdsByParams(array $params)
 * @method detailByProductOrderIdByParams(array $params)
 * @method createLogisticsByParams(array $params)
 */
class ProductOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动创建下一天的零售商城生产订单初始单号(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductOrderName () {
        return self::getClass()->setProductOrderName();
    }

    /**
     * 创建生产单
     *
     * @support  int $orderId 商城订单id [ require true ]
     * @support  int $orderItemId 商城订单明细id [ require true ]
     * @support  int $num 生产数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 生产订单详情
     *
     * @param  int $productOrderId 生产订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $productOrderId) {
        return self::getClass()->detail([
            "productOrderId" => $productOrderId,
        ]);
    }

    /**
     * 生产订单状态变动回调
     *
     * @param  array $data 生产订单状态变动回调数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function callBackProductStatusChange (array $data) {
        return self::getClass()->callBackProductStatusChange([
            "data" => $data,
        ]);
    }

    /**
     * 获取跳转编辑器的参数信息
     *
     * @support  int $userId 用户userId [ require true ]
     * @support  string $outOrderNo 第三方生产单标号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEditorJumpParams () {
        return self::getClass()->getEditorJumpParams();
    }

    /**
     * 通过skuid获取第三方模版数据
     *
     * @param  int $productSkuId 商品skuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOutTemplateBySkuId (int $productSkuId) {
        return self::getClass()->getOutTemplateBySkuId([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * 设置用户著作单作品缩略图
     *
     * @support  int $productOrderId 用户生产单id [ require true ]
     * @support  string $thumbnailUrl 用户作品缩略图url [ require true ]
     * @support  string $description 作品描述 require false
     * @support  string $name 作品名称 require false
     * @support  string $originImageUrl 原图url require false
     * @support  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserCompositionThumbnail () {
        return self::getClass()->setUserCompositionThumbnail();
    }

    /**
     * 生产订单列表-不分页
     *
     * @support  int $id 生产订单id require false
     * @support  array $ids 生产订单ids require false
     * @support  string $productOrderNo 生产订单编号 require false
     * @support  array $productOrderNos 生产订单编号数组 require false
     * @support  string $status 状态 require false
     * @support  array $statusList 状态列表 require false
     * @support  int $orderId 订单id require false
     * @support  array $orderIds 订单ids require false
     * @support  int $orderItemId 订单子表id require false
     * @support  array $orderItemIds 订单子表ids require false
     * @support  string $supplierCode 供应商code require false
     * @support  array $supplierCodes 供应商codes require false
     * @support  int $export 导出次数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 上传用户作品图
     *
     * @support  int $productOrderItemId 定制生产子表id require false
     * @support  int $productOrderId 生产订单id require false
     * @support  array $imageInfo 用户制作的图片详情 require false
     * @support  string $status 提交状态 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updateUserImageInfo () {
        return self::getClass()->updateUserImageInfo();
    }

    /**
     * 生产订单列表-分页
     *
     * @support  int $id 生产订单id require false
     * @support  array $ids 生产订单ids require false
     * @support  string $productOrderNo 生产订单编号 require false
     * @support  array $productOrderNos 生产订单编号数组 require false
     * @support  string $status 状态 require false
     * @support  array $statusList 状态列表 require false
     * @support  int $orderId 订单id require false
     * @support  array $orderIds 订单ids require false
     * @support  int $orderItemId 订单子表id require false
     * @support  array $orderItemIds 订单子表ids require false
     * @support  string $supplierCode 供应商code require false
     * @support  array $supplierCodes 供应商codes require false
     * @support  int $export 导出次数 require false
     * @support  int $page 第几页 [ require true ]
     * @support  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginator () {
        return self::getClass()->listWithPaginator();
    }

    /**
     * 根据生产单ids,增加导出次数
     *
     * @param  array $productOrderIds 生产订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function incrExportByProductOrderIds (array $productOrderIds) {
        return self::getClass()->incrExportByProductOrderIds([
            "productOrderIds" => $productOrderIds,
        ]);
    }

    /**
     * 根据生产单子单id,查看详情
     *
     * @param  int $productOrderId 生产订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByProductOrderId (int $productOrderId) {
        return self::getClass()->detailByProductOrderId([
            "productOrderId" => $productOrderId,
        ]);
    }

    /**
     * 单个生产订单批量绑定快递单号
     *
     * @param  string $productOrderNo 生产订单编号 [ require true ]
     * @param  array $logisticsNos 物流单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createLogistics (string $productOrderNo, array $logisticsNos) {
        return self::getClass()->createLogistics([
            "productOrderNo" => $productOrderNo,
            "logisticsNos" => $logisticsNos,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'ProductOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'ProductOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}