<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindUserCouponsByParams(array $params)
 * @method getCouponBySceneByParams(array $params)
 * @method getSkuEffectiveCouponsByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建绑定单个用户优惠卷
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $applyScene 应用场景 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindUserCoupons () {
        return self::getClass()->bindUserCoupons();
    }

    /**
     * 根据应用场景获取零售优惠券展示信息
     *
     * @support  int $userId 用户id 
     * @support  string $applyScene 应用场景 
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponByScene () {
        return self::getClass()->getCouponByScene();
    }

    /**
     * 检测商品信息和优惠券信息计算优惠信息
     *
     * @support  int $userId 用户id [ require true ]
     * @support  array $products 订单故障信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuEffectiveCoupons () {
        return self::getClass()->getSkuEffectiveCoupons();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}